unit PSFONTUN;

interface

const PERCENTD = 1;
      PERCENTL = 2;
      PERCENTR = 3;

type Font1ProcsRecordType = record
                          case kind : byte of
                               PERCENTD : (integertypevar : integer);
                               PERCENTL : (longtypevar : longint);
                               PERCENTR : (realtypevar : real);
     end;

     Font1Procs = object

public

procedure psClS(color : word);
procedure Draw1(x, y : integer; size, color : word);
procedure Draw2(x, y : integer; size, color : word);
procedure Draw3(x, y : integer; size, color : word);
procedure Draw4(x, y : integer; size, color : word);
procedure Draw5(x, y : integer; size, color : word);
procedure Draw6(x, y : integer; size, color : word);
procedure Draw7(x, y : integer; size, color : word);
procedure Draw8(x, y : integer; size, color : word);
procedure Draw9(x, y : integer; size, color : word);
procedure Draw0(x, y : integer; size, color : word);
procedure Drawa(x, y : integer; size, color : word);
procedure Drawz(x, y : integer; size, color : word);
procedure Drawq(x, y : integer; size, color : word);
procedure Draww(x, y : integer; size, color : word);
procedure Draws(x, y : integer; size, color : word);
procedure Drawx(x, y : integer; size, color : word);
procedure Drawe(x, y : integer; size, color : word);
procedure Drawd(x, y : integer; size, color : word);
procedure Drawc(x, y : integer; size, color : word);
procedure Drawr(x, y : integer; size, color : word);
procedure Drawf(x, y : integer; size, color : word);
procedure Drawv(x, y : integer; size, color : word);
procedure Drawt(x, y : integer; size, color : word);
procedure Drawg(x, y : integer; size, color : word);
procedure Drawb(x, y : integer; size, color : word);
procedure Drawy(x, y : integer; size, color : word);
procedure Drawh(x, y : integer; size, color : word);
procedure Drawn(x, y : integer; size, color : word);
procedure Drawu(x, y : integer; size, color : word);
procedure Drawj(x, y : integer; size, color : word);
procedure Drawm(x, y : integer; size, color : word);
procedure Drawi(x, y : integer; size, color : word);
procedure Drawk(x, y : integer; size, color : word);
procedure Drawo(x, y : integer; size, color : word);
procedure Drawl(x, y : integer; size, color : word);
procedure Drawp(x, y : integer; size, color : word);
procedure DrawSPC(x, y : integer; size, color : word);
procedure DrawEXC(x, y : integer; size, color : word);
procedure DrawNUM(x, y : integer; size, color : word);
procedure DrawQUES(x, y : integer; size, color : word);
procedure DrawDLR(x, y : integer; size, color : word);
procedure DrawPRC(x, y : integer; size, color : word);
procedure DrawBSH(x, y : integer; size, color : word);
procedure DrawODBQT(x, y : integer; size, color : word);
procedure DrawCDBQT(x, y : integer; size, color : word);
procedure DrawOSIQT(x, y : integer; size, color : word);
procedure DrawCSIQT(x, y : integer; size, color : word);
procedure DrawTIMES(x, y : integer; size, color : word);
procedure DrawAST(x, y : integer; size, color : word);
procedure DrawCPR(x, y : integer; size, color : word);
procedure DrawOPR(x, y : integer; size, color : word);
procedure DrawPLS(x, y : integer; size, color : word);
procedure DrawCMA(x, y : integer; size, color : word);
procedure DrawCLN(x, y : integer; size, color : word);
procedure DrawMNS(x, y : integer; size, color : word);
procedure DrawPRD(x, y : integer; size, color : word);
procedure DrawDIV(x, y : integer; size, color : word);
procedure DrawSLSH(x, y : integer; size, color : word);
procedure DrawSMICLN(x, y : integer; size, color : word);
procedure InitGraphLetts(YDX : real; tabl, abf, abt : integer);
procedure psprintf(x, y, siz, col, font : integer; chrstr : string; otherout : Font1Procsrecordtype);
function psscanf(scantype : string; var ptr) : byte;
procedure movetextcursor(x, y : integer);
procedure GetTextCursorXY(var x, y : integer);
procedure SetCurrColor(color : word);
procedure GetCurrColor(var color : word);
procedure SetCurrSize(size : word);
procedure GetCurrSize(var size : word);
procedure Destruct;

private
       textcursorx, textcursory : integer;
       currentcolor, currentsize : word;
end;

implementation

uses graph, crt;

var YDIVX : real;
    tablength,
    alarmbellfrequency,
    alarmbelltime : integer;


{************************ PsClearScr ******************************}

procedure Font1Procs.psClS(color : word);

begin
     setfillstyle(SolidFill, color);
     setcolor(color);
     bar(0, 0, GetMaxX, GetMaxY);
end;

{*********************** Font1Procs.Draw1 **************************}

procedure Font1Procs.Draw1(x, y : integer; size, color : word);

begin
     setcolor(color);
     line(x, trunc(y + size * YDIVX), x + size, trunc(y + size * YDIVX));
     line(x + size div 2, y, x + size div 2, trunc(y + size * YDIVX));
     line(x, trunc(y + size * YDIVX / 6), x + size div 2, y);
end; {Draw1}

{************************* Draw2 ****************************}

procedure Font1Procs.Draw2(x, y : integer; size, color : word);

begin
     setcolor(color);
     arc(x + size div 2, y + size div 2, trunc(330 - 2 * (ArcTan(2 * YDIVX - 1))), 180, size div 2);
     moveto(x, trunc(y + size * YDIVX));
     linerel(round((size*(YDIVX-1/2)*sin(2*ArcTan(2))))+round(size/7)-1,round((size*(YDIVX-1/2)*cos(2 * ArcTan(2)))));
     line(x, trunc(y + size * YDIVX), x + size, trunc(y + size * YDIVX));
end; {Draw2}

{*********************** Draw3 **************************}

procedure Font1Procs.Draw3(x, y : integer; size, color : word);

begin
     setcolor(color);
     ellipse(x + size div 2, trunc(y + size * YDIVX / 4), 270, 180, size div 2, trunc(size * YDIVX / 4));
     ellipse(x + size div 2, trunc(y + size * 3 * YDIVX / 4), 180, 90, size div 2, trunc(size * YDIVX / 4));
end; {Draw3}

{************************ Draw4 ****************************}

procedure Font1Procs.Draw4(x, y : integer; size, color : word);

begin
     setcolor(color);
     line(x, trunc(y + size * YDIVX / 2), x + size, trunc(y + size * YDIVX / 2));
     line(x + 3 * size div 4, y, x + 3 * size div 4, trunc(y + size * YDIVX));
     line(x + 3 * size div 4, y, x, trunc(y + size * YDIVX / 2));
end; {Draw4}

{*********************** Draw5 ***************************}

procedure Font1Procs.Draw5(x, y : integer; size, color : word);

begin
     setcolor(color);
     ellipse(x + size div 2, trunc(y + size * 3 * YDIVX / 4), 180, 90, size div 2, trunc(size * YDIVX / 4));
     line(x, y, x, trunc(y + size * YDIVX / 2));
     line(x, y, x + size, y);
     line(x, trunc(y + size * YDIVX / 2), x + size div 2, trunc(y + size * YDIVX / 2));
end; {Draw5}

{*********************** Draw6 ******************************}

procedure Font1Procs.Draw6(x, y : integer; size, color : word);

begin
     setcolor(color);
     ellipse(x + size div 2, trunc(y + size * 3 * YDIVX / 4), 0, 360, size div 2, trunc(size * YDIVX / 4));
     arc(trunc(x + size / 2), trunc(y + size / 2), 90, 180, trunc(size / 2));
     line(x, trunc(y + size * YDIVX / 4), x, trunc(y + 3 * size * YDIVX / 4));
end; {Draw6}

{*********************** Draw7 *****************************}

procedure Font1Procs.Draw7;

begin
     setcolor(color);
     line(x, y, x + size, y);
     line(x, trunc(y + size * YDIVX), x + size, y);
end; {Draw7}

{*********************** Draw8 ********************************}

procedure Font1Procs.Draw8;

begin
     setcolor(color);
     ellipse(x + size div 2, trunc(y + size * YDIVX / 4), 0, 360, size div 2, trunc(size * YDIVX / 4));
     ellipse(x + size div 2, trunc(y + size * 3 * YDIVX / 4), 0, 360, size div 2, trunc(size * YDIVX / 4));
end; {Draw8}

{*********************** Draw9 *******************************}

procedure Font1Procs.Draw9;

begin
     setcolor(color);
     ellipse(x + size div 2, trunc(y + size * YDIVX / 4), 0, 360, size div 2, trunc(size * YDIVX / 4));
     line(x + size div 2, trunc(y + size * YDIVX), x + size, trunc(y + size * YDIVX / 4));
end; {Draw9}

{**************************** Draw0 **********************************}

procedure Font1Procs.Draw0;

begin
     setcolor(color);
     ellipse(x + size div 2, trunc(y + size * YDIVX / 2), 0, 360, size div 2, trunc(size * YDIVX / 2));
end; {Draw0}

{********************** DrawSPC ****************************}

procedure Font1Procs.DrawSPC;

begin
end;

{********************** DrawEXC ***************************}

procedure Font1Procs.DrawEXC;

begin
     setcolor(color);
     line(x + size div 2, y, x + size div 2, trunc(y + 2 * size * YDIVX / 3));
     putpixel(x + size div 2, trunc(y + size * YDIVX), color);
end; {DrawEXC}

{********************** Draw# *************************}

procedure Font1Procs.DrawNUM;

begin
     setcolor(color);
     line(x, trunc(y + size * YDIVX / 3), x +  size, trunc(y + size * YDIVX / 3));
     line(x, trunc(y + 2 * size * YDIVX / 3), x +  size, trunc(y + 2 * size * YDIVX / 3));
     line(x + size div 3, y, x + size div 3, trunc(y + size * YDIVX));
     line(x + 2 * size div 3, y, x + 2 * size div 3, trunc(y + size * YDIVX));
end; {Draw#}

{************************* DrawQUES *****************************}

procedure Font1Procs.DrawQUES;

begin
     setcolor(color);
     arc(trunc(x + size / 2), trunc(y + size / 2), 0, 180, trunc(size / 2));
     ellipse(x + 3 * size div 4, y + size div 2, 270, 360, size div 4, trunc(size * YDIVX / 2 - size / 2));
     ellipse(x+3*size div 4, y+size div 2+2*trunc(size*YDIVX/2-size/2), 90, 180, size div 4, trunc(size*YDIVX/2-size/2));
     line(x + size div 2, y + size div 2 + 2 * trunc(size*YDIVX/2-size/2), x + size div 2, trunc(y + 5 / 6 * size * YDIVX));
     PutPixel(x + size div 2, trunc(y + size * YDIVX), color);
end; {DrawQUES}

{************************ DrawDLR ****************************}

procedure Font1Procs.DrawDLR;

begin
     DrawS(x + 1, y + 1, size - 2, color);
     line(x + size div 2, y, x + size div 2, trunc(y + size * YDIVX));
end; {DrawDLR}

{************************* DrawPRC ***************************}

procedure Font1Procs.DrawPRC;

begin
     setcolor(color);
     line(x + size, y, x, trunc(y + size * YDIVX));
     arc(x + size div 8, y + size div 8, 0, 360, size div 8);
     arc(x + 7 * size div 8, trunc(y + size * YDIVX - size div 8), 0, 360, size div 8);
end; {DrawPRC}

{************************* DrawBSH ***************************************}

procedure Font1Procs.DrawBSH;

begin
     setcolor(color);
     line(x, y, x + size, trunc(y + size * YDIVX));
end; {DrawBSH}

{************************* Draw" ***********************************}

procedure Font1Procs.DrawODBQT;

begin
     setcolor(color);
     setfillstyle(SolidFIll, color);
     circle(x + size div 4, y + size div 8, size div 8);
     floodfill(x + size div 4, y + size div 8, color);
     circle(x + 3 * size div 4, y + size div 8, size div 8);
     floodfill(x + 3 * size div 4, y + size div 8, color);
     ellipse(x + 3 * size div 8 - 1, y + size div 8 + 1, 180, 270, size div 8, trunc(size * YDIVX / 6));
     ellipse(x + 7 * size div 8 - 1, y + size div 8 + 1, 180, 270, size div 8, trunc(size * YDIVX / 6));

end;

procedure Font1Procs.DrawCDBQT;

begin
     setcolor(color);
     setfillstyle(SolidFill, color);
     circle(x + size div 4, y + size div 6 + 1 + trunc(size * YDIVX / 6) - size div 8, size div 8);
     floodfill(x + size div 4, y + size div 6 + 1 + trunc(size * YDIVX / 6) - size div 8, color);
     circle(x + 3 * size div 4, y + size div 6 + 1 + trunc(size * YDIVX / 6) - size div 8, size div 8);
     floodfill(x + 3 * size div 4, y + size div 6 + 1 + trunc(size * YDIVX / 6) - size div 8, color);
     ellipse(x + size div 4, y + size div 6, 330, 90, size div 8, trunc(size * YDIVX / 6));
     ellipse(x + 3 * size div 4, y + size div 8, 330, 90, size div 8, trunc(size * YDIVX / 6));

end;

procedure Font1Procs.DrawOSIQT;

begin
     setcolor(color);
     setfillstyle(SolidFill, color);
     circle(x + size div 2, y + size div 8, size div 8);
     floodfill(x + size div 2, y + size div 8, color);
     ellipse(x + 5 * size div 8 - 1, y + size div 8 + 1, 180, 270, size div 8, trunc(size * YDIVX / 6));
end;

procedure Font1Procs.DrawCSIQT;

begin
     setcolor(color);
     setfillstyle(SolidFill, color);
     circle(x + size div 2, y + size div 6 + 1 + trunc(size * YDIVX / 6) - size div 8, size div 8);
     floodfill(x + size div 2, y + size div 6 + 1 + trunc(size * YDIVX / 6) - size div 8, color);
     ellipse(x + size div 2, y + size div 8, 330, 90, size div 8, trunc(size * YDIVX / 6));
end;

{*****************************  (..) ***************************}

procedure Font1Procs.DrawOPR;

begin
     setcolor(color);
     ellipse(x + 3 * size div 4, trunc(y + size / 2 * YDIVX), 90, 270, size div 2, trunc(size / 2 * YDIVX));
end;

procedure Font1Procs.DrawCPR;

begin
     setcolor(color);
     ellipse(x + 3 * size div 4, trunc(y + size / 2 * YDIVX), 270, 90, size div 2, trunc(size / 2 * YDIVX));
end;

{****************************** Draw *, X ********************************}

procedure Font1Procs.DrawAST;

begin
     setcolor(color);
     line(x + size div 4, trunc(y + size / 2 * YDIVX), x + 3 * size div 4, trunc(y + size / 2 * YDIVX));
     moveto(x + size div 2, trunc(y + size * YDIVX / 2));
     moverel(size div 8, -1 * trunc(sqrt(3) * size / 8));
     linerel(-1 * size div 4, 2 * trunc(sqrt(3) * size / 8));
     moveto(x + size div 2, trunc(y + size * YDIVX / 2));
     moverel(-1 * size div 8, -1 * trunc(sqrt(3) * size / 8));
     linerel(size div 4, 2 * trunc(sqrt(3) * size / 8));
end;

procedure Font1Procs.DrawTIMES;

begin
     setcolor(color);
     line(x + size div 8, trunc(y + size / 2 * YDIVX - 3 * size / 8), x + 7 * size div 8, trunc(y + size/2*YDIVX+3*size/8));
     line(x + 7 * size div 8, trunc(y + size / 2 * YDIVX - 3 * size / 8), x + size div 8, trunc(y + size/2*YDIVX+3*size/8));
end;

{************************ DrawPLS ******************************}

procedure Font1Procs.DrawPLS;

begin
     setcolor(color);
     line(x, trunc(y + size * YDIVX / 2), x + size, trunc(y + size * YDIVX / 2));
     line(x + size div 2, trunc(y + size * YDIVX / 2 - size / 2), x + size div 2, trunc(y + size * YDIVX / 2 + size / 2));
end; {DrawPLS}

{************************ DrawCMA ******************************}

procedure Font1Procs.DrawCMA;

begin
     setcolor(color);
     setfillstyle(SolidFill, color);
     circle(x + size div 2, trunc(y + size * YDIVX - size / 8), size div 8);
     floodfill(x + size div 2, trunc(y + size * YDIVX - size / 8), color);
     ellipse(x + 5 * size div 8 - 1, trunc(y + size * YDIVX + size div 8 - 1), 270, 90, size div 8, trunc(size * YDIVX / 6));
end;

{************************** DrawMNS ****************************}

procedure Font1Procs.DrawMNS;

begin
     setcolor(color);
     line(x, trunc(y + size * YDIVX / 2), x + size, trunc(y + size * YDIVX / 2));
end; {DrawMNS}

{*********************** DrawPRD *************************}

procedure Font1Procs.DrawPRD;

begin
     setcolor(color);
     setfillstyle(SolidFill, color);
     circle(x + size div 2, trunc(y + size * YDIVX - size / 8), size div 8);
     floodfill(x + size div 2, trunc(y + size * YDIVX - size / 8), color);
end;

{*********************** Draw /,  DIV *****************************}

procedure Font1Procs.DrawSLSH;

begin
     setcolor(color);
     line(x, trunc(y + size * YDIVX), x + size, y);
end; {DrawSLSH}

procedure Font1Procs.DrawDIV;

begin
     DrawMNS(x, y, size, color);
     circle(x + size div 2, trunc(y + 3/4 * size * YDIVX), size div 8);
     circle(x + size div 2, trunc(y + 1/4 * size * YDIVX), size div 8);
     setfillstyle(SolidFill, color);
     floodfill(x + size div 2, trunc(y + 3/4 * size * YDIVX), color);
     floodfill(x + size div 2, trunc(y + 1/4 * size * YDIVX), color);
end; {DrawDIV}

{******************** Draw CLN, SMICLN *******************************}

procedure Font1Procs.DrawCLN;

begin
     setcolor(color);
     circle(x + size div 2, trunc(y + 3/4 * size * YDIVX), size div 8);
     circle(x + size div 2, trunc(y + 1/4 * size * YDIVX), size div 8);
     setfillstyle(SolidFill, color);
     floodfill(x + size div 2, trunc(y + 3/4 * size * YDIVX), color);
     floodfill(x + size div 2, trunc(y + 1/4 * size * YDIVX), color);
end;

procedure Font1Procs.DrawSMICLN;

begin
     setcolor(color);
     circle(x + size div 2, trunc(y + 1/4 * size * YDIVX), size div 8);
     setfillstyle(SolidFill, color);
     floodfill(x + size div 2, trunc(y + 1/4 * size * YDIVX), color);
     DrawCMA(x, trunc(y - size * YDIVX / 4 + size / 8), size, color);
end; {DrawSMICLN}

{*********************** DrawA **************************}

procedure Font1Procs.DrawA(x, y: integer; size, color : word);

begin
     setcolor(color);
     arc(trunc(x + size / 2), trunc(y + size / 2), 0, 180, trunc(size / 2));
     line(x, trunc(y + size / 2), x, trunc(y + YDIVX * size));
     line(x + size, trunc(y + size / 2), x + size, trunc(y + YDIVX * size));
     line(x, trunc(y + YDIVX * size / 2), x + size, trunc(y + YDIVX * size / 2));
end; {DrawA}

{*********************** DrawB ****************************}

procedure Font1Procs.DrawB;

begin
     setcolor(color);
     arc(trunc(x + size - (size * YDIVX / 4)), trunc(y + (size * YDIVX / 4)), 270, 90, trunc(size * YDIVX / 4));
     arc(trunc(x + size - (size * YDIVX / 4)), trunc(y + 3 * (size * YDIVX / 4)), 270, 90, trunc(size * YDIVX / 4));
     line(x, y, x, trunc(y + size * YDIVX));
     line(x, y, trunc(x + size - (size * YDIVX / 4)), y);
     line(x, trunc(y + YDIVX * size / 2), trunc(x + size - (size * YDIVX / 4)), trunc(y + YDIVX * size / 2));
     line(x, trunc(y + size * YDIVX), trunc(x + size - (size * YDIVX / 4)), trunc(y + size * YDIVX));
end; {DrawB}

{******************** DrawC *****************************}

procedure Font1Procs.DrawC;

begin
     setcolor(color);
     arc(trunc(x + size / 2), trunc(y + size / 2), 30, 180, trunc(size / 2));
     arc(trunc(x + size / 2), trunc(y + size * YDIVX - size / 2), 180, 330, trunc(size / 2));
     line(x, y + size div 2, x, trunc(y + size * YDIVX - size / 2));
end; {DrawC}

{******************** DrawD *****************************}

procedure Font1Procs.DrawD;

begin
     setcolor(color);
     arc(trunc(x + size - (size * YDIVX / 4)), trunc(y + (size * YDIVX / 4)), 0, 90, trunc(size * YDIVX / 4));
     arc(trunc(x + size - (size * YDIVX / 4)), trunc(y + 3 * (size * YDIVX / 4)), 270, 0, trunc(size * YDIVX / 4));
     line(trunc(x+size), trunc(y+size*YDIVX/4), trunc(x+size), trunc(y+YDIVX*size-size*YDIVX/4));
     line(x, y, x, trunc(y + size * YDIVX));
     line(x, y, trunc(x + size - (size * YDIVX / 4)), y);
     line(x, trunc(y + size * YDIVX), trunc(x + size - (size * YDIVX / 4)), trunc(y + size * YDIVX));
end; {DrawD}

{************************** DrawE *****************************}

procedure Font1Procs.DrawE;

begin
     setcolor(color);
     line(x, y, x, trunc(y + size * YDIVX));
     line(x, y, x + size, y);
     line(x, trunc(y + size * YDIVX / 2), trunc(x + 5 / 6 * size), trunc(y + size * YDIVX / 2));
     line(x, trunc(y + size * YDIVX), x + size, trunc(y + size * YDIVX));
end; {DrawE}

{************************* DrawF ****************************}

procedure Font1Procs.DrawF;

begin
     setcolor(color);
     line(x, y, x, trunc(y + size * YDIVX));
     line(x, y, x + size, y);
     line(x, trunc(y + size * YDIVX / 2), trunc(x + 5 / 6 * size), trunc(y + size * YDIVX / 2));
end; {DrawF}

{***************************** DrawG ********************************}

procedure Font1Procs.DrawG;

begin
     setcolor(color);
     arc(trunc(x + size / 2), trunc(y + size / 2), 30, 180, trunc(size / 2));
     arc(trunc(x + size / 2), trunc(y + size * YDIVX - size / 2), 180, 360, trunc(size / 2));
     line(x, y + size div 2, x, trunc(y + size * YDIVX - size / 2));
     line(x + size, trunc(y + size * YDIVX - size / 2), x + size, trunc(y + size * YDIVX / 2));
     line(x + size div 2, trunc(y + YDIVX * size / 2), x + size, trunc(y + YDIVX * size / 2));
end; {DrawG}

{**************************** DrawH **********************************}

procedure Font1Procs.DrawH;

begin
     setcolor(color);
     line(x, y, x, trunc(y + size * YDIVX));
     line(x + size, y, x + size, trunc(y + size * YDIVX));
     line(x, trunc(y + size * YDIVX / 2), trunc(x + size), trunc(y + size * YDIVX / 2));
end; {DrawH}

{************************* DrawI **************************}

procedure Font1Procs.DrawI;

begin
     setcolor(color);
     line(x, y, x + size, y);
     line(x, trunc(y + size * YDIVX), x + size, trunc(y + size * YDIVX));
     line(x + size div 2, y, x + size div 2, trunc(y + size * YDIVX));
end; {DrawI}

{*********************** DrawJ ************************}

procedure Font1Procs.DrawJ;

begin
     setcolor(color);
     arc(trunc(x + size / 2), trunc(y + size * YDIVX - size / 2), 180, 360, trunc(size / 2));
     line(x + size, y, x + size, trunc(y + size * YDIVX - size / 2));
     line(x, trunc(y + size * YDIVX / 2), x, trunc(y + size * YDIVX - size / 2));
end; {DrawJ}

{********************** DrawK *************************}

procedure Font1Procs.DrawK;

begin
     setcolor(color);
     line(x, y, x, trunc(y + size * YDIVX));
     line(x, trunc(y + size * YDIVX / 2), x + size, y);
     line(x, trunc(y + size * YDIVX / 2), x + size, trunc(y + size * YDIVX));
end; {DrawK}

{********************* DrawL **************************}

procedure Font1Procs.DrawL;

begin
     setcolor(color);
     line(x, y, x, trunc(y + size * YDIVX));
     line(x, trunc(y + size * YDIVX), x + size, trunc(y + size * YDIVX));
end; {DrawL}

{********************* DrawM ****************************}

procedure Font1Procs.DrawM;

begin
     setcolor(color);
     line(x, y, x, trunc(y + size * YDIVX));
     line(x + size, y, x + size, trunc(y + size * YDIVX));
     line(x, y, x + size div 2, trunc(y + size * YDIVX / 2));
     line(x + size, y, x + size div 2, trunc(y + size * YDIVX / 2));
end; {DrawM}

{************************* DrawN ******************************}

procedure Font1Procs.DrawN;

begin
     setcolor(color);
     line(x, y, x, trunc(y + size * YDIVX));
     line(x + size, y, x + size, trunc(y + size * YDIVX));
     line(x, y, x + size, trunc(y + size * YDIVX));
end; {DrawN}

{************************* DrawO *********************************}

procedure Font1Procs.DrawO;

begin
     setcolor(color);
     arc(trunc(x + size / 2), trunc(y + size / 2), 0, 180, trunc(size / 2));
     arc(trunc(x + size / 2), trunc(y + size * YDIVX - size / 2), 180, 360, trunc(size / 2));
     line(x, y + size div 2, x, trunc(y + size * YDIVX - size / 2));
     line(x + size, y + size div 2, x + size, trunc(y + size * YDIVX - size / 2));
end; {DrawO}

{******************** DrawP **************************}

procedure Font1Procs.DrawP;

begin
     setcolor(color);
     arc(trunc(x + size - (size * YDIVX / 4)), trunc(y + (size * YDIVX / 4)), 270, 90, trunc(size * YDIVX / 4));
     line(x, y, x, trunc(y + size * YDIVX));
     line(x, y, trunc(x + size - (size * YDIVX / 4)), y);
     line(x, trunc(y + YDIVX * size / 2), trunc(x + size - (size * YDIVX / 4)), trunc(y + YDIVX * size / 2));
end; {DrawP}

{******************** DrawQ ****************************}

procedure Font1Procs.DrawQ;

begin
     setcolor(color);
     arc(trunc(x + size / 2), trunc(y + size / 2), 0, 180, trunc(size / 2));
     arc(trunc(x + size / 2), trunc(y + size * YDIVX - size / 2), 180, 360, trunc(size / 2));
     line(x, y + size div 2, x, trunc(y + size * YDIVX - size / 2));
     line(x + size, y + size div 2, x + size, trunc(y + size * YDIVX - size / 2));
     line(trunc(x + size / 2), trunc(y + size * YDIVX - size / 2), x + size, trunc(y + size * YDIVX));
end; {DrawQ}

{******************** DrawR **************************}

procedure Font1Procs.DrawR;

begin
     setcolor(color);
     arc(trunc(x + size - (size * YDIVX / 4)), trunc(y + (size * YDIVX / 4)), 270, 90, trunc(size * YDIVX / 4));
     line(x, y, x, trunc(y + size * YDIVX));
     line(x, y, trunc(x + size - (size * YDIVX / 4)), y);
     line(x, trunc(y + YDIVX * size / 2), trunc(x + size - (size * YDIVX / 4)), trunc(y + YDIVX * size / 2));
     line(x, trunc(y + size * YDIVX / 2), x + size, trunc(y + size * YDIVX));
end; {DrawR}

{*********************** DrawS **************************}

procedure Font1Procs.DrawS;

begin
     setcolor(color);
     ellipse(x + size div 2, trunc(y + size * YDIVX / 4), 0, 270, size div 2, trunc(size * YDIVX / 4));
     ellipse(x + size div 2, trunc(y + size * 3 * YDIVX / 4), 180, 90, size div 2, trunc(size * YDIVX / 4));
end; {DrawS}

{*********************** DrawT **************************}

procedure Font1Procs.DrawT;

begin
     setcolor(color);
     line(x, y, x + size, y);
     line(x + size div 2, y, x + size div 2, trunc(y + size * YDIVX));
end; {DrawT}

{*********************** DrawU **************************}

procedure Font1Procs.DrawU;

begin
     setcolor(color);
     arc(trunc(x + size / 2), trunc(y + size * YDIVX - size / 2), 180, 360, trunc(size / 2));
     line(x + size, y, x + size, trunc(y + size * YDIVX - size / 2));
     line(x, y, x, trunc(y + size * YDIVX - size / 2));
end; {DrawU}

{*********************** DrawV ***************************}

procedure Font1Procs.DrawV;

begin
     setcolor(color);
     line(x, y, x + size div 2, trunc(y + size * YDIVX));
     line(x + size, y, x + size div 2, trunc(y + size * YDIVX));
end; {DrawV}

{*************************** DrawW ************************}

procedure Font1Procs.DrawW;

begin
     setcolor(color);
     line(x, y, x + size div 4, trunc(y + size * YDIVX));
     line(x + size, y, x + 3 * size div 4, trunc(y + size * YDIVX));
     line(x + size div 2, trunc(y + size * YDIVX / 2), x + size div 4, trunc(y + size * YDIVX));
     line(x + size div 2, trunc(y + size * YDIVX / 2), x + 3 * size div 4, trunc(y + size * YDIVX));
end; {DrawW}

{*********************** DrawX **************************}

procedure Font1Procs.DrawX;

begin
     setcolor(color);
     line(x, y, x + size, trunc(y + size * YDIVX));
     line(x, trunc(y + size * YDIVX), x + size, y);
end; {DrawX}

{*********************** DrawY *************************}

procedure Font1Procs.DrawY;

begin
     setcolor(color);
     arc(trunc(x + size / 2), trunc(y + size * YDIVX / 2 - size / 2), 180, 0, size div 2);
     line(trunc(x + size / 2), trunc(y + size * YDIVX / 2), x + size div 2, trunc(y + size * YDIVX));
     line(x, y, x, trunc(y + size * YDIVX / 2 - size / 2));
     line(x + size, y, x + size, trunc(y + size * YDIVX / 2 - size / 2));
end; {DrawY}

{************************** DrawZ ****************************}

procedure Font1Procs.DrawZ;

begin
     setcolor(color);
     line(x, y, x + size, y);
     line(x, trunc(y + size * YDIVX), x + size, trunc(y + size * YDIVX));
     line(x + size, y, x, trunc(y + size * YDIVX));
end; {DrawZ}

{***************************** Init Graph Letts ***************************}

procedure Font1Procs.InitGraphLetts;

var ErCd, GrMd, GrDr : integer;

begin
     GrDr := Detect;
     InitGraph(GrDr, GrMd, 'G:\tp\bgi');
     ErCd := GraphResult;
     if ErCd <> GrOK then begin
        writeln('Graphics error: ', GraphErrorMsg(ErCd));
        writeln('Exiting...');
        halt;
     end; {if}

     YDIVX := YDX;
     tablength := tabl;
     alarmbellfrequency := abf;
     alarmbelltime := abt;

     movetextcursor(0, 0);
     SetCurrColor(12);
     SetCurrSize(10);

end; {Initletters}

{************************ MoveTextCursor *************************}

procedure Font1Procs.movetextcursor;

begin
     textcursorx := x;
     textcursory := y;
end;

{************************* GetTextcursorXY *****************************}

procedure Font1Procs.GetTextCursorXY(var x, y : integer);

begin
     x := textcursorx;
     y := textcursory;
end;

{***************************** Set Current Size *****************************}

procedure Font1Procs.SetCurrSize;

begin
     CurrentSize := size;
end;

{********************** Set Current Color ************************}

procedure Font1Procs.SetCurrColor;

begin
     CurrentColor := color;
end;

{*************************** Get Current Size ***************************}

procedure Font1Procs.GetCurrSize;

begin
     size := CurrentSize;
end;

{************************ Get Current Color ****************************}

procedure Font1Procs.GetCurrColor;

begin
     color := CurrentColor;
end;

{******************************** Destruct *********************************}

procedure Font1Procs.Destruct;

begin
     closegraph;
     textcolor(15);
     textbackground(0);
end;


{************************** Ps Printf ******************************}

procedure Font1Procs.psprintf(x, y, siz, col, font : integer; chrstr : string; otherout : Font1Procsrecordtype);

{======================= Real To String =========================}

function RealToString(realtostrnum : real) : string;

var {ctr, len, decpt, downtonum : byte;
    realtmp : real;
    plus, decimal : boolean;                   }
    returnstring : string;
    {inttmp : integer;                          }

begin
     {inttmp := Int(realtostrnum);
     if (realtostrnum >= 0) then begin
        plus := true;
        downtonum := 1;
        ctr := 0
     end
     else begin
         plus := false;
         downtonum := 2;
         ctr := 1;
     end;
     decimal := false;
     while (abs(inttmp) >= 1) do begin
           ctr := ctr + 1;
           inttmp := (inttmp - inttmp mod 10) div 10;
     end; {while}
     {decimal := true;
     ctr := ctr + 1;
     decpt := ctr;
     returnstring[decpt] := '.';
     realtmp := realtostrnum - realtmp := int(realtostrnum);
     while (realtmp <> 0) do begin
           ctr := ctr + 1;
           realtmp := realtmp * 10 - int(realtmp * 10);
     end;
     len := ctr;
     realtmp := int(realtostrnum);

     for ctr := decpt - 1 downto downtonum do begin
         returnstring[ctr] := realtmp mod 10;
         realtmp := (realtmp - realtmp mod 10) div 10;
     end; {for}
     {realtmp := frac(realtostrnum);
     for ctr := decpt + 1 to len do begin
         returnstring[ctr] := int(realtmp * 10);
         realtmp := realtmp * 10 - int(realtmp * 10);
     end; {for}
     {returnstring[0] := len;
     returnstring[len + 1] := #0;
     RealToString := returnstring;     }

     str(realtostrnum, returnstring);
     RealToString := returnstring;
end;

{======================= Long To String =========================}

function LongToString(longtostrnum : longint) : string;

var ctr, len : byte;
    stringtoreturn : string;
    longtmp : longint;
    plus : boolean;

begin
     if (longtostrnum >= 0) then begin
        plus := true;
        ctr := 0
     end
     else begin
         plus := false;
         ctr := 1;
     end;
     longtmp := longtostrnum;
     while (longtmp <> 0) do begin
           ctr := ctr + 1;
           longtmp := (longtmp - longtmp mod 10) div 10;
     end; {while}
     len := ctr;
     longtmp := longtostrnum;
     if plus then
        for ctr := len downto 1 do begin
            stringtoreturn[ctr] := chr(longtmp mod 10 + 48);
            longtmp := (longtmp - longtmp mod 10) div 10;
        end {for}
     else begin
         stringtoreturn[1] := '-';
         for ctr := len + 1 downto 2 do begin
            stringtoreturn[ctr] := chr(48 + longtmp mod 10);
            longtmp := (longtmp - longtmp mod 10) div 10;
         end; {for}
     end;
     LongToString := stringtoreturn;
end;


{++++++++++++++++++++++++ Main ++++++++++++++++++++++++++++++++}

var ctr, ctr1 : integer;
    xpos, ypos : integer;
    backslash : boolean;
    quote : boolean;
    percent : boolean;
    size, color : word;
    stringtmp : string;

begin
     ctr := 1;
     if ((x >= 0) and (y >= 0)) then begin
        xpos := x;
        ypos := y;
     end
     else
         GetTextCursorXY(xpos, ypos);
     if (col <= 0) then
        GetCurrColor(color)
     else
         color := col;
     if (siz >= 0) then
        size := siz
     else
         GetCurrSize(size);
     backslash := false;
     quote := false;
     percent := false;
     while chrstr[ctr] in [chr(32)..chr(126)] do begin
           case chrstr[ctr] of
                'A' : if backslash then begin
                         sound(ALARMBELLFREQUENCY);
                         delay(ALARMBELLTIME);
                         nosound;
                         xpos := xpos - size - size div 3 - 1;
                         backslash := false;
                      end
                      else
                          DrawA(xpos, ypos, size, color);
                'B' : DrawB(xpos, ypos, size, color);
                'C' : DrawC(xpos, ypos, size, color);
                'D' : if (percent and (otherout.kind = PERCENTD)) then begin
                         str(otherout.integertypevar, stringtmp);
                         psprintf(-1, -1, -1, -1, 1, stringtmp);
                         percent := false;
                      end;
                      else
                          DrawD(xpos, ypos, size, color);
                'E' : DrawE(xpos, ypos, size, color);
                'F' : DrawF(xpos, ypos, size, color);
                'G' : DrawG(xpos, ypos, size, color);
                'H' : DrawH(xpos, ypos, size, color);
                'I' : DrawI(xpos, ypos, size, color);
                'J' : DrawJ(xpos, ypos, size, color);
                'K' : DrawK(xpos, ypos, size, color);
                'L' : if (percent and (otherout.kind = PERCENTL)) then begin
                         psprintf(-1, -1, -1, -1, LongToString(otherout.longtypevar));
                DrawL(xpos, ypos, size, color);
                'M' : DrawM(xpos, ypos, size, color);
                'N' : if backslash then begin
                         ypos := ypos + trunc(size * YDIVX) + size div 2 + 1;
                         xpos := x - size - size div 3 - 1;
                         backslash := false;
                      end
                      else
                          DrawN(xpos, ypos, size, color);
                'O' : DrawO(xpos, ypos, size, color);
                'P' : DrawP(xpos, ypos, size, color);
                'Q' : DrawQ(xpos, ypos, size, color);
                'R' : begin
                      if backslash then begin
                         xpos := x mod (size + size div 3);
                         ypos := ypos + trunc(size * YDIVX) + size div 2 + 1;
                         xpos := xpos - size - size div 3 - 1;
                         backslash := false;
                      end
                      else
                      if (percent and (otherout.kind = PERCENTR)) then begin
                         percent := false;
                         psprintf(-1, -1, -1, -1, RealToString(otherout.realtypevar));
                      end
                      else
                          DrawR(xpos, ypos, size, color);
                'S' : DrawS(xpos, ypos, size, color);
                'T' : if backslash then begin
                         xpos := xpos + (size + size div 3 + 1) * (TABLENGTH - 1);
                         backslash := false;
                      end
                      else
                          DrawT(xpos, ypos, size, color);
                'U' : DrawU(xpos, ypos, size, color);
                'V' : DrawV(xpos, ypos, size, color);
                'W' : DrawW(xpos, ypos, size, color);
                'X' : DrawX(xpos, ypos, size, color);
                'Y' : DrawY(xpos, ypos, size, color);
                'Z' : DrawZ(xpos, ypos, size, color);
                '0' : Draw0(xpos, ypos, size, color);
                '1' : Draw1(xpos, ypos, size, color);
                '2' : Draw2(xpos, ypos, size, color);
                '3' : Draw3(xpos, ypos, size, color);
                '4' : Draw4(xpos, ypos, size, color);
                '5' : Draw5(xpos, ypos, size, color);
                '6' : Draw6(xpos, ypos, size, color);
                '7' : Draw7(xpos, ypos, size, color);
                '8' : Draw8(xpos, ypos, size, color);
                '9' : Draw9(xpos, ypos, size, color);
                ' ' : DrawSPC(xpos, ypos, size, color);
                '!' : DrawEXC(xpos, ypos, size, color);
                '#' : DrawNUM(xpos, ypos, size, color);
                '?' : DrawQUES(xpos, ypos, size, color);
                '$' : DrawDLR(xpos, ypos, size, color);
                '%' : if backslash then begin
                         DrawPRC(xpos, ypos, size, color);
                         backslash := false;
                      end
                      else
                          percent := true;
                '(' : DrawOPR(xpos, ypos, size, color);
                ')' : DrawCPR(xpos, ypos, size, color);
                '*' : if backslash then begin
                         DrawTIMES(xpos, ypos, size, color);
                         backslash := false;
                      end
                      else
                          DrawAST(xpos, ypos, size, color);
                '"' : begin
                      if backslash then begin
                         quote := false;
                         xpos := xpos - size - size div 3 - 1;
                         backslash := false;
                      end
                      else
                          case quote of
                           false : begin
                                        DrawODBQT(xpos, ypos, size, color);
                                        quote := true;
                                   end;
                           true  : begin
                                        DrawCDBQT(xpos, ypos, size, color);
                                        quote := false;
                                   end;
                          end;
                      end;
                '''' : DrawCSIQT(xpos, ypos, size, color);
                '`' : DrawOSIQT(xpos, ypos, size, color);
                '+' : DrawPLS(xpos, ypos, size, color);
                ',' : DrawCMA(xpos, ypos, size, color);
                '-' : DrawMNS(xpos, ypos, size, color);
                '.' : DrawPRD(xpos, ypos, size, color);
                '/' : if backslash then begin
                         DrawDIV(xpos, ypos, size, color);
                         backslash := false;
                      end
                      else
                          DrawSLSH(xpos, ypos, size, color);
                ':' : DrawCLN(xpos, ypos, size, color);
                ';' : DrawSMICLN(xpos, ypos, size, color);
                '\' : if backslash then begin
                         DrawBSH(xpos, ypos, size, color);
                         backslash := false;
                      end
                      else begin
                          backslash := true;
                          xpos := xpos - size - size div 3 - 1;
                      end;
           end; {case}
           xpos := xpos + size + size div 3 + 1;
           if xpos > GetMaxX - size then begin
              xpos := x mod (size + size div 3);
              ypos := ypos + trunc(size * YDIVX) + size div 2 + 1;
           end; {if}
           ctr := ctr + 1;
     end; {while}
     for ctr1 := 1 to (ctr + 1) do
         chrstr[ctr1] := #0;

     movetextcursor(xpos, ypos);
     SetCurrColor(color);
     SetCurrSize(size);

end;


{************************* Ps Scanf *************************}

function Font1Procs.psscanf;

var inte : integer;
    str : string;
    realnum : real;
    longnum : longint;
    integerreturn : integer absolute ptr;
    stringreturn : string absolute ptr;
    realreturn : real absolute ptr;
    longreturn : longint absolute ptr;

{====================== Ps Scan Int ================================}

function psscanint(var integertpnum : integer) : byte;

var number : integer;
    digit : char;
    plusorminus : shortint;

begin
     digit := ReadKey;
     psprintf(-1, -1, -1, -1, 1, digit);
     number := 0;
     plusorminus := 1;
     case digit of
          #45 : begin
                plusorminus := -1;
                digit := ReadKey;
                psprintf(-1, -1, -1, -1, 1, digit);
                end;
          #43 : begin
                plusorminus := 1;
                digit := ReadKey;
                psprintf(-1, -1, -1, -1, 1, digit);
                end;
     end; {case}
     while (digit in [#48..#57]) do begin
           if ((number > 3276) or (number < -3276)) then begin
              integertpnum := 0;
              psscanint := 1;
              exit;
           end
           else begin
                number := number * 10 + plusorminus * (ord(digit) - ord('0'));
                psprintf(-1, -1, -1, -1, 1, digit);
                digit := ReadKey;
           end;
     end; {while}

     integertpnum := number;

end;

{======================== Ps Scan Long ===================================}

function psscanlong(var longtpnum : longint) : byte;

var number : longint;
    digit : char;
    plusorminus : shortint;

begin
     digit := ReadKey;
     psprintf(-1, -1, -1, -1, 1, digit);
     number := 0;
     plusorminus := 1;
     case digit of
          #45 : begin
                plusorminus := -1;
                digit := ReadKey;
                psprintf(-1, -1, -1, -1, 1, digit);
                end;
          #43 : begin
                plusorminus := 1;
                digit := ReadKey;
                psprintf(-1, -1, -1, -1, 1, digit);
                end;
     end;
     while (digit in [#48..#57]) do begin
           if ((number > 214748364) or (number < -214748364)) then begin
              longtpnum := 0;
              psscanlong := 1;
              exit;
           end
           else begin
                number := number * 10 + plusorminus * (ord(digit) - ord(0));
                psprintf(-1, -1, -1, -1, 1, digit);
                digit := ReadKey;
           end;
     end; {while}

     longtpnum := number;

end;

{============================== Ps Scan Str ================================}

function psscanstr(var strtpnum : string) : byte;

var stringtoret : string;

begin
     stringtoret[0] := #0;

     {[#96..#122, #48..#57, #42, #46, #65..#93]    }
end;

function psscanreal(var realtpnum : real) : byte;

begin
end;

{++++++++++++++++++++++++++++ Ps Scanf Main ++++++++++++++++++++++++++++++++}

begin
     case scantype[2] of
          'l' : begin                                            {X}
                if (psscanlong(longnum) = 1) then
                   psscanf := 1
                else
                    longreturn := longnum;
                end;
          'd' : begin
                if (psscanint(inte) = 1) then                     {X}
                   psscanf := 1
                else
                    integerreturn := inte;
                end;
          'r' : begin
                if (psscanreal(realnum) = 1) then
                   psscanf := 1                                 {  }
                else
                    realreturn := realnum;
                end;
          's' : begin
                if (psscanstr(str) = 1) then
                   psscanf := 1                                  { }
                else
                    stringreturn := str;
                end;
     end;
end;



end.