unit PMseV101;
{unit for mouse interface}

interface {start interface sector}

type
    MouseObject = object {Mouse Object type def.}

                  function ColdReset(NumButtons : integer) : boolean;
                     {cold reset}
                  procedure ShowMouse;
                     {shows mouse cursor}
                  procedure HideMouse;
                     {hides mouse cursor}
                  procedure GetClicks(var RtBut, MidBut, LtBut : boolean; var row, col : integer);
                     {Gets button data}
                  procedure MoveCursor(row, col : integer);
                     {Moves mouse cursor}
                  function LastPress(ButNum : integer; var row, col : integer) : integer;
                     {Gets last button press data}
                  function LastRelease(ButNum : integer; var row, col : integer) : integer;
                     {Gets last release data}
                  procedure HorizLimit(Min, Max : integer);
                     {Sets horizontal cursor limit}
                  procedure VertLimit(Min, Max : integer);
                     {Sets veritcal cursor limit}
                  procedure SetSensitivity(Horiz, Vert, DblSpeed : integer);
                     {Sets mouse sensitivity}
                  procedure GetSensitivity(var Horiz, Vert, DblSpeed : integer);
                     {Gets mouse sensitivity}
                  procedure DefineMicPixRatio(Horiz, Vert : integer);
                     {Sets mickey to pixel ratio.  A mickey is used in measuring mouse motion}
                  function SoftReset(NumButtons : integer) : boolean;
                     {Software reset of mouse}

                  end; {object}

implementation {start implementation sector}

uses
    DOS; {uses the DOS unit.  This is used for BIOS mouse interrupts.}

const
     LEFT_BUTTON = 0;   {Symbolic constant used for the left button}
     MIDDLE_BUTTON = 2; {Symbolic constant used for the middle button}
     RIGHT_BUTTON = 1;  {Symbolic constant used for the right button}

function MouseObject.ColdReset;

var
   regs : registers; {DOS registers}

begin {function}
     regs.ax := $0000; {Cold reset for mouse}
     intr($33, regs);
     ColdReset := regs.ax = $FFFF; {Returns a false if an error occured}
     case regs.bx of {Returns the number of buttons}
          $0000 : NumButtons := 0;        {Calculation based on DOS register return bits}
          $0002, $FFFF : NumButtons := 2; {Calculation based on DOS register return bits}
          $0003 : NumButtons := 3         {Calculation based on DOS register return bits}
     end {case}
end; {function}

procedure MouseObject.ShowMouse;

var
   regs : registers; {DOS registers}

begin {procedure}
     regs.ax := $0001; {Calls BIOS interrupt to show mouse}
     intr($33, regs)
end; {procedure}

procedure MouseObject.HideMouse;

var
   regs : registers; {DOS registers}

begin {procedure}
     regs.ax := $0002; {Calls BIOS interrupt for hiding mouse}
     intr($33, regs)
end; {procedure}

procedure MouseObject.GetClicks;

var
   regs : registers; {DOS registers}

begin {procedure}
     regs.ax := $0003; {calls BIOS interrupt service for mouse status}
     intr($33, regs);
     if regs.bx div 4 > 0 then {Checks return bits to see if the middle button (if it exists) is down}
        MidBut := true {The return value is true}
     else
         MidBut := false; {The return value is false}
     if regs.bx div 2 mod 2 > 0 then {Checks to see if the right button is down}
        RtBut := true {The return value is true}
     else
         RtBut := false; {The return value is false}
     if regs.bx mod 2 > 0 then {Checks to see if the left button is down}
        LtBut := true {The return value is true}
     else
         LtBut := false; {The return value is false}
     row := regs.dx; {The row of the mouse cursor is returned}
     col := regs.cx  {The column of the mouse cursor is returned}
end; {procedure}

procedure MouseObject.MoveCursor;

var
   regs : registers; {DOS registers}

begin {procedure}
     regs.ax := $0004; {Calls BIOS interrupt service to position the cursor}
     regs.cx := col; {Sends BIOS the new column of the cursor}
     regs.dx := row; {Sends BIOS the new row of the cursor}
     intr($33, regs) {Sends all data to the BIOS register, where it is processed}
end; {procedure}

function MouseObject.LastPress;

var
   regs : registers; {DOS registers}

begin {function}
     regs.ax := $0005; {Calls BIOS interrupt service for specific button press data}
     regs.bx := ButNum; {Sends BIOS the button to analyze}
     intr($33, regs); {Sends BIOS all data}
     LastPress := regs.bx; {Returns the number of times the specified button has been pressed since the last call}
     row := regs.dx; {Returns the row location of the last press}
     col := regs.cx  {Returns the column location of the last press}
end; {function}

function MouseObject.LastRelease;

var
   regs : registers; {DOS registers}

begin {function}
     regs.ax := $0006;  {Calls BIOS interrupt service for specific button release data}
     regs.bx := ButNum; {Sends BIOS the button to analyze}
     intr($33, regs);   {Sends BIOS all data}
     LastRelease := regs.bx; {Returns the number of times the specified button has been released since the last call}
     row := regs.dx; {Returns the row location of the last release}
     col := regs.cx  {Returns the column location of the last release}
end; {function}

procedure MouseObject.HorizLimit;

var
   regs : registers; {DOS registers}

begin {procedure}
     regs.ax := $0007; {Calls BIOS interrupt service for horizontal limit settings}
     regs.cx := Min; {Sends BIOS the minimum column that can be attained by the mouse cursor}
     regs.dx := Max; {Sends BIOS the maximum column that can be attained by the mouse cursor}
     intr($33, regs) {Sends BIOS all data}
end; {procedure}

procedure MouseObject.VertLimit;

var
   regs : registers; {DOS registers}

begin {procedure}
     regs.ax := $0008; {Calls BIOS interrupt service for the vertical limit settings}
     regs.cx := Min; {Sends BIOS the minimum row that can be attained by the mouse cursor}
     regs.dx := Max; {Sends BIOS the maximum row that can be attained by the mouse cursor}
     intr($33, regs) {Sends BIOS all data}
end; {procedure}

procedure MouseObject.SetSensitivity;

var
   regs : registers; {DOS registers}

begin {procedure}
     regs.ax := $001A; {Calls BIOS interrupt service for setting sensitivity settings}
     regs.bx := Horiz; {Sends BIOS horizontal sensitivity}
     regs.cx := Vert;  {Sends BIOS vertical sensitivity}
     regs.dx := DblSpeed; {Sends BIOS the double speed threshold}
     intr($33, regs) {Sends BIOS all data}
end; {procedure}

procedure MouseObject.GetSensitivity;

var
   regs : registers; {DOS registers}

begin {procedure}
     regs.ax := $001B; {Calls BIOS interrupt service for getting sensitivity settings}
     intr($33, regs);
     Horiz := regs.bx; {Returns horizontal sensitivity}
     Vert := regs.cx;  {Returns vertical sensitivity}
     DblSpeed := regs.dx {Returns double speed threshold}
end; {procedure}

procedure MouseObject.DefineMicPixRatio;

var
   regs : registers; {DOS regsiters}

begin {procedure}
     regs.ax := $000F; {Calls BIOS interrupt service for setting mickey to pix. ratio}
     regs.cx := Horiz; {Sends BIOS horizontal mic/pix ratio}
     regs.dx := Vert;  {Sends BIOS vertical mic/pix ratio}
     intr($33, regs)   {Sends BIOS all data}
end; {procedure}

function MouseObject.SoftReset;

var
   regs : registers; {DOS registers}

begin {function}
     regs.ax := $0021; {Calls BIOS interrupt service for software reset}
     intr($33, regs);
     SoftReset := regs.ax = $FFFF; {Checks for errors.  If an error occurred, then the function returns false.}
     NumButtons := regs.bx {The number of buttons on the mouse is returned}
end; {function}

end. {unit}