unit PFONTV12;

{********************************************************************
NAME: Po-Shen Loh.
TITLE: Po-Shen's font unit #1 (version 1.2).
CONTENTS: Font1Procs (font #1 procedures):
             Draw*(x coordinate, y coordinate, width in pixels, color(0..15).
             psClS(color(0..15).
             InitGraphLetts(ratio of height in pixels to the width in pixels,
                tab length, alarm bell frequency, path of graphics drivers,
                alarm bell time.
             psscanf(scan type, var: str, real, int, etc.). Returns a 1 if
                there is an error, and a 0 if there isn't.
             psprintf(x coordinate, y coordinate, width in pixels,
                color(0..15), font(in this ver. pass the value 1, char. str.).
             MoveTextCursor(x destination, y destination).
             GetTextCursorXY(vars: x coordinate, y coordinate).
             SetCurrColor(color (0..15)).
             GetCurrColor(var: color (0..15)).
             SetCurrSize(width in pixels).
             GetCurrSize(var: width in pixels).
             Destruct.

             Font1Procs is an object type that must be declared before it
                        may be used.

          Conversions:
             LongToString(long integer). Returns a string.
             IntToString(integer number). Returns a string.

TABLES:
       Color Table: 0 = black             8 = dark gray
                    1 = blue              9 = light blue
                    2 = green             10 = light green
                    3 = cyan              11 = light cyan
                    4 = red               12 = light red
                    5 = magenta           13 = light magenta
                    6 = brown             14 = yellow
                    7 = light gray        15 = white
       Scan Types:  %d = integer          %s = string
                    %l = long integer     %r = real
       Abbrev.:     SPC = space           EXC = !
                    NUM = #               QUES = ?
                    DLR = $               PRC = %
                    BSH = \               ODBQT = ``
                    CDBQT = ''            OSIQT = `
                    CSIQT = '             TIMES = x
                    AST = *               CPR = )
                    OPR = (               PLS = +
                    LES = <               GRE = >
                    LESOREQ = <=          GREOREQ = >=
                    APPROX = .            SIM = ~
                             =                   ~
                    EQU = =               OBR = [
                    CBR = ]               OBRACE = {
                    CBRACE = }     {      CAR = ^
                    UND = _               TIL = ~
                    CMA = ,               CLN = :
                    MNS = -               PRD = .
                    DIV = +               SLSH = /
                    SMICLN = ;

************************************************************}



{======================= Interface ========================}

interface

type paratype = array[1..5] of packed array[1..60] of char; {type def. used by flash para.}
     Font1Procs = object

     public  {start of public sector}

     procedure psClS(color : word);
     procedure Draw1(x, y : integer; size, color : word);
     procedure Draw2(x, y : integer; size, color : word);
     procedure Draw3(x, y : integer; size, color : word);
     procedure Draw4(x, y : integer; size, color : word);
     procedure Draw5(x, y : integer; size, color : word);
     procedure Draw6(x, y : integer; size, color : word);
     procedure Draw7(x, y : integer; size, color : word);
     procedure Draw8(x, y : integer; size, color : word);
     procedure Draw9(x, y : integer; size, color : word);
     procedure Draw0(x, y : integer; size, color : word);
     procedure Drawa(x, y : integer; size, color : word);
     procedure Drawz(x, y : integer; size, color : word);
     procedure Drawq(x, y : integer; size, color : word);
     procedure Draww(x, y : integer; size, color : word);
     procedure Draws(x, y : integer; size, color : word);
     procedure Drawx(x, y : integer; size, color : word);
     procedure Drawe(x, y : integer; size, color : word);
     procedure Drawd(x, y : integer; size, color : word);
     procedure Drawc(x, y : integer; size, color : word);
     procedure Drawr(x, y : integer; size, color : word);
     procedure Drawf(x, y : integer; size, color : word);
     procedure Drawv(x, y : integer; size, color : word);
     procedure Drawt(x, y : integer; size, color : word);
     procedure Drawg(x, y : integer; size, color : word);
     procedure Drawb(x, y : integer; size, color : word);
     procedure Drawy(x, y : integer; size, color : word);
     procedure Drawh(x, y : integer; size, color : word);
     procedure Drawn(x, y : integer; size, color : word);
     procedure Drawu(x, y : integer; size, color : word);
     procedure Drawj(x, y : integer; size, color : word);
     procedure Drawm(x, y : integer; size, color : word);
     procedure Drawi(x, y : integer; size, color : word);
     procedure Drawk(x, y : integer; size, color : word);
     procedure Drawo(x, y : integer; size, color : word);
     procedure Drawl(x, y : integer; size, color : word);
     procedure Drawp(x, y : integer; size, color : word);
     procedure DrawSPC(x, y : integer; size, color : word);
     procedure DrawEXC(x, y : integer; size, color : word);
     procedure DrawNUM(x, y : integer; size, color : word);
     procedure DrawQUES(x, y : integer; size, color : word);
     procedure DrawDLR(x, y : integer; size, color : word);
     procedure DrawPRC(x, y : integer; size, color : word);
     procedure DrawBSH(x, y : integer; size, color : word);
     procedure DrawODBQT(x, y : integer; size, color : word);
     procedure DrawCDBQT(x, y : integer; size, color : word);
     procedure DrawOSIQT(x, y : integer; size, color : word);
     procedure DrawCSIQT(x, y : integer; size, color : word);
     procedure DrawTIMES(x, y : integer; size, color : word);
     procedure DrawAST(x, y : integer; size, color : word);
     procedure DrawCPR(x, y : integer; size, color : word);
     procedure DrawOPR(x, y : integer; size, color : word);
     procedure DrawPLS(x, y : integer; size, color : word);
     procedure DrawLES(x, y : integer; size, color : word);
     procedure DrawGRE(x, y : integer; size, color : word);
     procedure DrawLESOREQ(x, y : integer; size, color : word);
     procedure DrawGREOREQ(x, y : integer; size, color : word);
     procedure DrawEQU(x, y : integer; size, color : word);
     procedure DrawSIM(x, y : integer; size, color : word);
     procedure DrawAPPROX(x, y : integer; size, color : word);
     procedure DrawOBR(x, y : integer; size, color : word);
     procedure DrawCBR(x, y : integer; size, color : word);
     procedure DrawCAR(x, y : integer; size, color : word);
     procedure DrawUND(x, y : integer; size, color : word);
     procedure DrawOBRACE(x, y : integer; size, color : word);
     procedure DrawCBRACE(x, y : integer; size, color : word);
     procedure DrawTIL(x, y : integer; size, color : word);
     procedure DrawCMA(x, y : integer; size, color : word);
     procedure DrawCLN(x, y : integer; size, color : word);
     procedure DrawMNS(x, y : integer; size, color : word);
     procedure DrawPRD(x, y : integer; size, color : word);
     procedure DrawDIV(x, y : integer; size, color : word);
     procedure DrawSLSH(x, y : integer; size, color : word);
     procedure DrawSMICLN(x, y : integer; size, color : word);
     procedure InitGraphLetts(path : string; YDX : real; tabl, abf, abt : integer);
     procedure psprintf(x, y, siz, col, font : integer; chrstr : string);
     procedure psflashpara(x, y, siz, col, xin, yin : integer; rows, cols : byte; delaytime : integer; para : paratype);
     function psscanf(scantype : string; var ptr) : byte;
     procedure movetextcursor(x, y : integer);
     procedure GetTextCursorXY(var x, y : integer);
     procedure SetCurrColor(color : word);
     procedure GetCurrColor(var color : word);
     procedure SetCurrSize(size : word);
     procedure GetCurrSize(var size : word);
     procedure Destruct;

     private     {start of private sector}

     textcursorx, textcursory : integer;
     currentcolor, currentsize : word;
     YDIVX : real;
     tablength, alarmbellfrequency, alarmbelltime : integer;

     end;   {object}

function IntToString(inttoconvert : integer) : string;  {converts integers to strings}
function LongToString(longtostrnum : longint) : string; {converts longints to strings}

{========================== Implementation ==============================}

implementation

uses graph, crt, pBGIdriv, pBGIfont;  {includes these two units}

{~~~~~~~~~~~~~~~~~~~ Beginning of Font1Procs ~~~~~~~~~~~~~~~~~~~~~~}


{************************ PsClearScr ******************************}
{clears the screen, with the background color that was passed}

procedure Font1Procs.psClS(color : word);

begin {procedure}
     setfillstyle(SolidFill, color); {sets the fill color to the one passed}
     setcolor(color);                {sets the draw color to the one passed}
     bar(0, 0, GetMaxX, GetMaxY);    {draws a huge rectangle around the screen}
     MoveTextCursor(2, 2);           {moves text cursor to (2, 2)}
end;  {procedure}

{<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
            CHARACTER DRAWING ROUTINES START HERE
            ALL CHARS ARE DRAWN WITH LINES AND/OR
            ARCS.
>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>}

{*********************** Font1Procs.Draw1 **************************}

procedure Font1Procs.Draw1(x, y : integer; size, color : word);

begin
     setcolor(color);
     line(x, trunc(y + size * YDIVX), x + size, trunc(y + size * YDIVX));
     line(x + size div 2, y, x + size div 2, trunc(y + size * YDIVX));
     line(x, trunc(y + size * YDIVX / 6), x + size div 2, y);
end; {Draw1}

{************************* Draw2 ****************************}

procedure Font1Procs.Draw2(x, y : integer; size, color : word);

begin
     setcolor(color);
     arc(x + size div 2, y + size div 2, trunc(330 - 2 * (ArcTan(2 * YDIVX - 1))), 180, size div 2);
     moveto(x, trunc(y + size * YDIVX));
     linerel(round((size*(YDIVX-1/2)*sin(2*ArcTan(2))))+round(size/7)-1,round((size*(YDIVX-1/2)*cos(2 * ArcTan(2)))));
     line(x, trunc(y + size * YDIVX), x + size, trunc(y + size * YDIVX));
end; {Draw2}

{*********************** Draw3 **************************}

procedure Font1Procs.Draw3(x, y : integer; size, color : word);

begin
     setcolor(color);
     ellipse(x + size div 2, trunc(y + size * YDIVX / 4), 270, 180, size div 2, trunc(size * YDIVX / 4));
     ellipse(x + size div 2, trunc(y + size * 3 * YDIVX / 4), 180, 90, size div 2, trunc(size * YDIVX / 4));
end; {Draw3}

{************************ Draw4 ****************************}

procedure Font1Procs.Draw4(x, y : integer; size, color : word);

begin
     setcolor(color);
     line(x, trunc(y + size * YDIVX / 2), x + size, trunc(y + size * YDIVX / 2));
     line(x + 3 * size div 4, y, x + 3 * size div 4, trunc(y + size * YDIVX));
     line(x + 3 * size div 4, y, x, trunc(y + size * YDIVX / 2));
end; {Draw4}

{*********************** Draw5 ***************************}

procedure Font1Procs.Draw5(x, y : integer; size, color : word);

begin
     setcolor(color);
     ellipse(x + size div 2, trunc(y + size * 3 * YDIVX / 4), 180, 90, size div 2, trunc(size * YDIVX / 4));
     line(x, y, x, trunc(y + size * YDIVX / 2));
     line(x, y, x + size, y);
     line(x, trunc(y + size * YDIVX / 2), x + size div 2, trunc(y + size * YDIVX / 2));
end; {Draw5}

{*********************** Draw6 ******************************}

procedure Font1Procs.Draw6(x, y : integer; size, color : word);

begin
     setcolor(color);
     ellipse(x + size div 2, trunc(y + size * 3 * YDIVX / 4), 0, 360, size div 2, trunc(size * YDIVX / 4));
     arc(trunc(x + size / 2), trunc(y + size / 2), 90, 180, trunc(size / 2));
     line(x, trunc(y + size * YDIVX / 4), x, trunc(y + 3 * size * YDIVX / 4));
end; {Draw6}

{*********************** Draw7 *****************************}

procedure Font1Procs.Draw7;

begin
     setcolor(color);
     line(x, y, x + size, y);
     line(x, trunc(y + size * YDIVX), x + size, y);
end; {Draw7}

{*********************** Draw8 ********************************}

procedure Font1Procs.Draw8;

begin
     setcolor(color);
     ellipse(x + size div 2, trunc(y + size * YDIVX / 4), 0, 360, size div 2, trunc(size * YDIVX / 4));
     ellipse(x + size div 2, trunc(y + size * 3 * YDIVX / 4), 0, 360, size div 2, trunc(size * YDIVX / 4));
end; {Draw8}

{*********************** Draw9 *******************************}

procedure Font1Procs.Draw9;

begin
     setcolor(color);
     ellipse(x + size div 2, trunc(y + size * YDIVX / 4), 0, 360, size div 2, trunc(size * YDIVX / 4));
     line(x + size div 2, trunc(y + size * YDIVX), x + size, trunc(y + size * YDIVX / 4));
end; {Draw9}

{**************************** Draw0 **********************************}

procedure Font1Procs.Draw0;

begin
     setcolor(color);
     ellipse(x + size div 2, trunc(y + size * YDIVX / 2), 0, 360, size div 2, trunc(size * YDIVX / 2));
end; {Draw0}

{********************** DrawSPC ****************************}

procedure Font1Procs.DrawSPC;

begin
end;

{********************** DrawEXC ***************************}

procedure Font1Procs.DrawEXC;

begin
     setcolor(color);
     line(x + size div 2, y, x + size div 2, trunc(y + 2 * size * YDIVX / 3));
     putpixel(x + size div 2, trunc(y + size * YDIVX), color);
end; {DrawEXC}

{********************** Draw# *************************}

procedure Font1Procs.DrawNUM;

begin
     setcolor(color);
     line(x, trunc(y + size * YDIVX / 3), x +  size, trunc(y + size * YDIVX / 3));
     line(x, trunc(y + 2 * size * YDIVX / 3), x +  size, trunc(y + 2 * size * YDIVX / 3));
     line(x + size div 3, y, x + size div 3, trunc(y + size * YDIVX));
     line(x + 2 * size div 3, y, x + 2 * size div 3, trunc(y + size * YDIVX));
end; {Draw#}

{************************* DrawQUES *****************************}

procedure Font1Procs.DrawQUES;

begin
     setcolor(color);
     arc(trunc(x + size / 2), trunc(y + size / 2), 0, 180, trunc(size / 2));
     ellipse(x + 3 * size div 4, y + size div 2, 270, 360, size div 4, trunc(size * YDIVX / 2 - size / 2));
     ellipse(x+3*size div 4, y+size div 2+2*trunc(size*YDIVX/2-size/2), 90, 180, size div 4, trunc(size*YDIVX/2-size/2));
     line(x + size div 2, y + size div 2 + 2 * trunc(size*YDIVX/2-size/2), x + size div 2, trunc(y + 5 / 6 * size * YDIVX));
     PutPixel(x + size div 2, trunc(y + size * YDIVX), color);
end; {DrawQUES}

{************************ DrawDLR ****************************}

procedure Font1Procs.DrawDLR;

begin
     DrawS(x + 1, y + 1, size - 2, color);
     line(x + size div 2, y, x + size div 2, trunc(y + size * YDIVX));
end; {DrawDLR}

{************************* DrawPRC ***************************}

procedure Font1Procs.DrawPRC;

begin
     setcolor(color);
     line(x + size, y, x, trunc(y + size * YDIVX));
     arc(x + size div 8, y + size div 8, 0, 360, size div 8);
     arc(x + 7 * size div 8, trunc(y + size * YDIVX - size div 8), 0, 360, size div 8);
end; {DrawPRC}

{************************* DrawBSH ***************************************}

procedure Font1Procs.DrawBSH;

begin
     setcolor(color);
     line(x, y, x + size, trunc(y + size * YDIVX));
end; {DrawBSH}

{************************* Draw" ***********************************}

procedure Font1Procs.DrawODBQT;

begin
     setcolor(color);
     setfillstyle(SolidFIll, color);
     circle(x + size div 4, y + size div 8, size div 8);
     floodfill(x + size div 4, y + size div 8, color);
     circle(x + 3 * size div 4, y + size div 8, size div 8);
     floodfill(x + 3 * size div 4, y + size div 8, color);
     ellipse(x + 3 * size div 8 - 1, y + size div 8 + 1, 180, 270, size div 8, trunc(size * YDIVX / 6));
     ellipse(x + 7 * size div 8 - 1, y + size div 8 + 1, 180, 270, size div 8, trunc(size * YDIVX / 6));

end;

procedure Font1Procs.DrawCDBQT;

begin
     setcolor(color);
     setfillstyle(SolidFill, color);
     circle(x + size div 4, y + size div 6 + 1 + trunc(size * YDIVX / 6) - size div 8, size div 8);
     floodfill(x + size div 4, y + size div 6 + 1 + trunc(size * YDIVX / 6) - size div 8, color);
     circle(x + 3 * size div 4, y + size div 6 + 1 + trunc(size * YDIVX / 6) - size div 8, size div 8);
     floodfill(x + 3 * size div 4, y + size div 6 + 1 + trunc(size * YDIVX / 6) - size div 8, color);
     ellipse(x + size div 4, y + size div 6, 330, 90, size div 8, trunc(size * YDIVX / 6));
     ellipse(x + 3 * size div 4, y + size div 8, 330, 90, size div 8, trunc(size * YDIVX / 6));

end;

procedure Font1Procs.DrawOSIQT;

begin
     setcolor(color);
     setfillstyle(SolidFill, color);
     circle(x + size div 2, y + size div 8, size div 8);
     floodfill(x + size div 2, y + size div 8, color);
     ellipse(x + 5 * size div 8 - 1, y + size div 8 + 1, 180, 270, size div 8, trunc(size * YDIVX / 6));
end;

procedure Font1Procs.DrawCSIQT;

begin
     setcolor(color);
     setfillstyle(SolidFill, color);
     circle(x + size div 2, y + size div 6 + 1 + trunc(size * YDIVX / 6) - size div 8, size div 8);
     floodfill(x + size div 2, y + size div 6 + 1 + trunc(size * YDIVX / 6) - size div 8, color);
     ellipse(x + size div 2, y + size div 8, 330, 90, size div 8, trunc(size * YDIVX / 6));
end;

{*****************************  (..) ***************************}

procedure Font1Procs.DrawOPR;

begin
     setcolor(color);
     ellipse(x + 3 * size div 4, trunc(y + size / 2 * YDIVX), 90, 270, size div 2, trunc(size / 2 * YDIVX));
end;

procedure Font1Procs.DrawCPR;

begin
     setcolor(color);
     ellipse(x + 3 * size div 4, trunc(y + size / 2 * YDIVX), 270, 90, size div 2, trunc(size / 2 * YDIVX));
end;

{****************************** Draw *, X ********************************}

procedure Font1Procs.DrawAST;

begin
     setcolor(color);
     line(x + size div 4, trunc(y + size / 2 * YDIVX), x + 3 * size div 4, trunc(y + size / 2 * YDIVX));
     moveto(x + size div 2, trunc(y + size * YDIVX / 2));
     moverel(size div 8, -1 * trunc(sqrt(3) * size / 8));
     linerel(-1 * size div 4, 2 * trunc(sqrt(3) * size / 8));
     moveto(x + size div 2, trunc(y + size * YDIVX / 2));
     moverel(-1 * size div 8, -1 * trunc(sqrt(3) * size / 8));
     linerel(size div 4, 2 * trunc(sqrt(3) * size / 8));
end;

procedure Font1Procs.DrawTIMES;

begin
     setcolor(color);
     line(x + size div 8, trunc(y + size / 2 * YDIVX - 3 * size / 8), x + 7 * size div 8, trunc(y + size/2*YDIVX+3*size/8));
     line(x + 7 * size div 8, trunc(y + size / 2 * YDIVX - 3 * size / 8), x + size div 8, trunc(y + size/2*YDIVX+3*size/8));
end;

{************************ DrawPLS ******************************}

procedure Font1Procs.DrawPLS;

begin
     setcolor(color);
     line(x, trunc(y + size * YDIVX / 2), x + size, trunc(y + size * YDIVX / 2));
     line(x + size div 2, trunc(y + size * YDIVX / 2 - size / 2), x + size div 2, trunc(y + size * YDIVX / 2 + size / 2));
end; {DrawPLS}

{************************ DrawCMA ******************************}

procedure Font1Procs.DrawCMA;

begin
     setcolor(color);
     setfillstyle(SolidFill, color);
     circle(x + size div 2, trunc(y + size * YDIVX - size / 8), size div 8);
     floodfill(x + size div 2, trunc(y + size * YDIVX - size / 8), color);
     ellipse(x + 5 * size div 8 - 1, trunc(y + size * YDIVX + size div 8 - 1), 270, 90, size div 8, trunc(size * YDIVX / 6));
end;

{************************** DrawMNS ****************************}

procedure Font1Procs.DrawMNS;

begin
     setcolor(color);
     line(x, trunc(y + size * YDIVX / 2), x + size, trunc(y + size * YDIVX / 2));
end; {DrawMNS}

{*********************** DrawPRD *************************}

procedure Font1Procs.DrawPRD;

begin
     setcolor(color);
     setfillstyle(SolidFill, color);
     circle(x + size div 2, trunc(y + size * YDIVX - size / 8), size div 8);
     floodfill(x + size div 2, trunc(y + size * YDIVX - size / 8), color);
end;

{*********************** Draw /,  DIV *****************************}

procedure Font1Procs.DrawSLSH;

begin
     setcolor(color);
     line(x, trunc(y + size * YDIVX), x + size, y);
end; {DrawSLSH}

procedure Font1Procs.DrawDIV;

begin
     DrawMNS(x, y, size, color);
     circle(x + size div 2, trunc(y + 3/4 * size * YDIVX), size div 8);
     circle(x + size div 2, trunc(y + 1/4 * size * YDIVX), size div 8);
     setfillstyle(SolidFill, color);
     floodfill(x + size div 2, trunc(y + 3/4 * size * YDIVX), color);
     floodfill(x + size div 2, trunc(y + 1/4 * size * YDIVX), color);
end; {DrawDIV}

{******************** Draw CLN, SMICLN *******************************}

procedure Font1Procs.DrawCLN;

begin
     setcolor(color);
     circle(x + size div 2, trunc(y + 3/4 * size * YDIVX), size div 8);
     circle(x + size div 2, trunc(y + 1/4 * size * YDIVX), size div 8);
     setfillstyle(SolidFill, color);
     floodfill(x + size div 2, trunc(y + 3/4 * size * YDIVX), color);
     floodfill(x + size div 2, trunc(y + 1/4 * size * YDIVX), color);
end;

procedure Font1Procs.DrawSMICLN;

begin
     setcolor(color);
     circle(x + size div 2, trunc(y + 1/4 * size * YDIVX), size div 8);
     setfillstyle(SolidFill, color);
     floodfill(x + size div 2, trunc(y + 1/4 * size * YDIVX), color);
     DrawCMA(x, trunc(y - size * YDIVX / 4 + size / 8), size, color);
end; {DrawSMICLN}

{******************* DrawLES **********************}

procedure Font1Procs.DrawLES;

begin
     setcolor(color);
     line(x + size, trunc(y + size * YDIVX / 4), x, trunc(y + size * YDIVX / 2));
     line(x + size, trunc(y + 3 * size * YDIVX / 4), x, trunc(y + size * YDIVX / 2));
end;

procedure Font1Procs.DrawGRE;

begin
     setcolor(color);
     line(x, trunc(y + size * YDIVX / 4), x + size, trunc(y + size * YDIVX / 2));
     line(x, trunc(y + 3 * size * YDIVX / 4), x + size, trunc(y + size * YDIVX / 2));
end;

procedure Font1Procs.DrawLESOREQ;

begin
     DrawLES(x, y, size, color);
     line(x + size, trunc(y + 3 * size * YDIVX / 4 + 1), x, trunc(y + size * YDIVX / 2 + 1));
end;

procedure Font1Procs.DrawGREOREQ;

begin
     DrawGRE(x, y, size, color);
     line(x, trunc(y + 3 * size * YDIVX / 4 + 1), x + size, trunc(y + size * YDIVX / 2 + 1));
end;

procedure Font1Procs.DrawEQU;

begin
     setcolor(color);
     line(x, trunc(y + size * YDIVX / 2 - 1), x + size, trunc(y + size * YDIVX / 2 - 1));
     line(x, trunc(y + size * YDIVX / 2 + 1), x + size, trunc(y + size * YDIVX / 2 + 1));
end;

procedure Font1Procs.DrawSIM;          {\~}

begin
     setcolor(color);
     ellipse(x + size div 4, trunc(y + size * YDIVX / 2), 180, 360, size div 4, trunc(size * YDIVX / 8));
     ellipse(x + 3 * size div 4, trunc(y + size * YDIVX / 2), 0, 180, size div 4, trunc(size * YDIVX / 8));
end;

procedure Font1Procs.DrawAPPROX;

begin
     setcolor(color);
     ellipse(x + size div 4, trunc(y + size * YDIVX / 2 - 1), 180, 360, size div 4, trunc(size * YDIVX / 8));
     ellipse(x + 3 * size div 4, trunc(y + size * YDIVX / 2 - 1), 0, 180, size div 4, trunc(size * YDIVX / 8));
     ellipse(x + size div 4, trunc(y + size * YDIVX / 2 + 1), 180, 360, size div 4, trunc(size * YDIVX / 8));
     ellipse(x + 3 * size div 4, trunc(y + size * YDIVX / 2 + 1), 0, 180, size div 4, trunc(size * YDIVX / 8));
end;

{******************* Draw Brackets ******************}

procedure Font1Procs.DrawOBR;

begin
     setcolor(color);
     line(x + 3 * size div 8, y, x + 3 * size div 8, trunc(y + size * YDIVX));
     line(x + 3 * size div 8, y, x + 5 * size div 8, y);
     line(x + 3 * size div 8, trunc(y + size * YDIVX), x + 5 * size div 8, trunc(y + size * YDIVX));
end;

procedure Font1Procs.DrawCBR;

begin
     setcolor(color);
     line(x + 5 * size div 8, y, x + 5 * size div 8, trunc(y + size * YDIVX));
     line(x + 3 * size div 8, y, x + 5 * size div 8, y);
     line(x + 3 * size div 8, trunc(y + size * YDIVX), x + 5 * size div 8, trunc(y + size * YDIVX));
end;

{********************* Draw Carat **********************}

procedure Font1Procs.DrawCAR;

begin
     setcolor(color);
     line(x + size div 2, y, x + size, trunc(y + size * YDIVX * 3/8));
     line(x + size div 2, y, x, trunc(y + size * YDIVX * 3/8));
end;

{******************** Draw Underscore ************************}

procedure Font1Procs.DrawUND;

begin
     setcolor(color);
     line(x, trunc(y + size * YDIVX), x + size, trunc(y + size * YDIVX));
end;

{********************** Draw Braces *************************}

procedure Font1Procs.DrawOBRACE;

begin
     setcolor(color);
     ellipse(x + 5 * size div 8, trunc(y + size * YDIVX / 4), 90, 180, size div 8, trunc(y + size * YDIVX / 4));
     ellipse(x + 5 * size div 8, trunc(y + 3 * size * YDIVX / 4), 180, 270, size div 8, trunc(y + size * YDIVX / 4));
     arc(x + 3 * size div 8, trunc(y + size * YDIVX / 2 - size / 8), 270, 360, size div 8);
     arc(x + 3 * size div 8, trunc(y + size * YDIVX / 2 + size / 8), 0, 90, size div 8);
     line(x + size div 2, trunc(y + size * YDIVX / 4), x + size div 2, trunc(y + size * YDIVX / 2 - size / 8));
     line(x + size div 2, trunc(y + 3 * size * YDIVX / 4), x + size div 2, trunc(y + size * YDIVX / 2 + size / 8));
end;

procedure Font1Procs.DrawCBRACE;

begin
     setcolor(color);
     ellipse(x + 3 * size div 8, trunc(y + size * YDIVX / 4), 0, 90, size div 8, trunc(y + size * YDIVX / 4));
     ellipse(x + 3 * size div 8, trunc(y + 3 * size * YDIVX / 4), 270, 360, size div 8, trunc(y + size * YDIVX / 4));
     arc(x + 5 * size div 8, trunc(y + size * YDIVX / 2 - size / 8), 270, 360, size div 8);
     arc(x + 5 * size div 8, trunc(y + size * YDIVX / 2 + size / 8), 0, 90, size div 8);
     line(x + size div 2, trunc(y + size * YDIVX / 4), x + size div 2, trunc(y + size * YDIVX / 2 - size / 8));
     line(x + size div 2, trunc(y + 3 * size * YDIVX / 4), x + size div 2, trunc(y + size * YDIVX / 2 + size / 8));
end;

{********************** Draw Tilde **************************}

procedure Font1Procs.DrawTIL;

begin
     setcolor(color);
     ellipse(x + size div 4, trunc(size * YDIVX / 8), 180, 360, size div 4, trunc(size * YDIVX / 8));
     ellipse(x + 3 * size div 4, trunc(size * YDIVX / 8), 0, 180, size div 4, trunc(size * YDIVX / 8));
end;

{*********************** DrawA **************************}

procedure Font1Procs.DrawA(x, y: integer; size, color : word);

begin
     setcolor(color);
     arc(trunc(x + size / 2), trunc(y + size / 2), 0, 180, trunc(size / 2));
     line(x, trunc(y + size / 2), x, trunc(y + YDIVX * size));
     line(x + size, trunc(y + size / 2), x + size, trunc(y + YDIVX * size));
     line(x, trunc(y + YDIVX * size / 2), x + size, trunc(y + YDIVX * size / 2));
end; {DrawA}

{*********************** DrawB ****************************}

procedure Font1Procs.DrawB;

begin
     setcolor(color);
     arc(trunc(x + size - (size * YDIVX / 4)), trunc(y + (size * YDIVX / 4)), 270, 90, trunc(size * YDIVX / 4));
     arc(trunc(x + size - (size * YDIVX / 4)), trunc(y + 3 * (size * YDIVX / 4)), 270, 90, trunc(size * YDIVX / 4));
     line(x, y, x, trunc(y + size * YDIVX));
     line(x, y, trunc(x + size - (size * YDIVX / 4)), y);
     line(x, trunc(y + YDIVX * size / 2), trunc(x + size - (size * YDIVX / 4)), trunc(y + YDIVX * size / 2));
     line(x, trunc(y + size * YDIVX), trunc(x + size - (size * YDIVX / 4)), trunc(y + size * YDIVX));
end; {DrawB}

{******************** DrawC *****************************}

procedure Font1Procs.DrawC;

begin
     setcolor(color);
     arc(trunc(x + size / 2), trunc(y + size / 2), 30, 180, trunc(size / 2));
     arc(trunc(x + size / 2), trunc(y + size * YDIVX - size / 2), 180, 330, trunc(size / 2));
     line(x, y + size div 2, x, trunc(y + size * YDIVX - size / 2));
end; {DrawC}

{******************** DrawD *****************************}

procedure Font1Procs.DrawD;

begin
     setcolor(color);
     arc(trunc(x + size - (size * YDIVX / 4)), trunc(y + (size * YDIVX / 4)), 0, 90, trunc(size * YDIVX / 4));
     arc(trunc(x + size - (size * YDIVX / 4)), trunc(y + 3 * (size * YDIVX / 4)), 270, 0, trunc(size * YDIVX / 4));
     line(trunc(x+size), trunc(y+size*YDIVX/4), trunc(x+size), trunc(y+YDIVX*size-size*YDIVX/4));
     line(x, y, x, trunc(y + size * YDIVX));
     line(x, y, trunc(x + size - (size * YDIVX / 4)), y);
     line(x, trunc(y + size * YDIVX), trunc(x + size - (size * YDIVX / 4)), trunc(y + size * YDIVX));
end; {DrawD}

{************************** DrawE *****************************}

procedure Font1Procs.DrawE;

begin
     setcolor(color);
     line(x, y, x, trunc(y + size * YDIVX));
     line(x, y, x + size, y);
     line(x, trunc(y + size * YDIVX / 2), trunc(x + 5 / 6 * size), trunc(y + size * YDIVX / 2));
     line(x, trunc(y + size * YDIVX), x + size, trunc(y + size * YDIVX));
end; {DrawE}

{************************* DrawF ****************************}

procedure Font1Procs.DrawF;

begin
     setcolor(color);
     line(x, y, x, trunc(y + size * YDIVX));
     line(x, y, x + size, y);
     line(x, trunc(y + size * YDIVX / 2), trunc(x + 5 / 6 * size), trunc(y + size * YDIVX / 2));
end; {DrawF}

{***************************** DrawG ********************************}

procedure Font1Procs.DrawG;

begin
     setcolor(color);
     arc(trunc(x + size / 2), trunc(y + size / 2), 30, 180, trunc(size / 2));
     arc(trunc(x + size / 2), trunc(y + size * YDIVX - size / 2), 180, 360, trunc(size / 2));
     line(x, y + size div 2, x, trunc(y + size * YDIVX - size / 2));
     line(x + size, trunc(y + size * YDIVX - size / 2), x + size, trunc(y + size * YDIVX / 2));
     line(x + size div 2, trunc(y + YDIVX * size / 2), x + size, trunc(y + YDIVX * size / 2));
end; {DrawG}

{**************************** DrawH **********************************}

procedure Font1Procs.DrawH;

begin
     setcolor(color);
     line(x, y, x, trunc(y + size * YDIVX));
     line(x + size, y, x + size, trunc(y + size * YDIVX));
     line(x, trunc(y + size * YDIVX / 2), trunc(x + size), trunc(y + size * YDIVX / 2));
end; {DrawH}

{************************* DrawI **************************}

procedure Font1Procs.DrawI;

begin
     setcolor(color);
     line(x, y, x + size, y);
     line(x, trunc(y + size * YDIVX), x + size, trunc(y + size * YDIVX));
     line(x + size div 2, y, x + size div 2, trunc(y + size * YDIVX));
end; {DrawI}

{*********************** DrawJ ************************}

procedure Font1Procs.DrawJ;

begin
     setcolor(color);
     arc(trunc(x + size / 2), trunc(y + size * YDIVX - size / 2), 180, 360, trunc(size / 2));
     line(x + size, y, x + size, trunc(y + size * YDIVX - size / 2));
     line(x, trunc(y + size * YDIVX / 2), x, trunc(y + size * YDIVX - size / 2));
end; {DrawJ}

{********************** DrawK *************************}

procedure Font1Procs.DrawK;

begin
     setcolor(color);
     line(x, y, x, trunc(y + size * YDIVX));
     line(x, trunc(y + size * YDIVX / 2), x + size, y);
     line(x, trunc(y + size * YDIVX / 2), x + size, trunc(y + size * YDIVX));
end; {DrawK}

{********************* DrawL **************************}

procedure Font1Procs.DrawL;

begin
     setcolor(color);
     line(x, y, x, trunc(y + size * YDIVX));
     line(x, trunc(y + size * YDIVX), x + size, trunc(y + size * YDIVX));
end; {DrawL}

{********************* DrawM ****************************}

procedure Font1Procs.DrawM;

begin
     setcolor(color);
     line(x, y, x, trunc(y + size * YDIVX));
     line(x + size, y, x + size, trunc(y + size * YDIVX));
     line(x, y, x + size div 2, trunc(y + size * YDIVX / 2));
     line(x + size, y, x + size div 2, trunc(y + size * YDIVX / 2));
end; {DrawM}

{************************* DrawN ******************************}

procedure Font1Procs.DrawN;

begin
     setcolor(color);
     line(x, y, x, trunc(y + size * YDIVX));
     line(x + size, y, x + size, trunc(y + size * YDIVX));
     line(x, y, x + size, trunc(y + size * YDIVX));
end; {DrawN}

{************************* DrawO *********************************}

procedure Font1Procs.DrawO;

begin
     setcolor(color);
     arc(trunc(x + size / 2), trunc(y + size / 2), 0, 180, trunc(size / 2));
     arc(trunc(x + size / 2), trunc(y + size * YDIVX - size / 2), 180, 360, trunc(size / 2));
     line(x, y + size div 2, x, trunc(y + size * YDIVX - size / 2));
     line(x + size, y + size div 2, x + size, trunc(y + size * YDIVX - size / 2));
end; {DrawO}

{******************** DrawP **************************}

procedure Font1Procs.DrawP;

begin
     setcolor(color);
     arc(trunc(x + size - (size * YDIVX / 4)), trunc(y + (size * YDIVX / 4)), 270, 90, trunc(size * YDIVX / 4));
     line(x, y, x, trunc(y + size * YDIVX));
     line(x, y, trunc(x + size - (size * YDIVX / 4)), y);
     line(x, trunc(y + YDIVX * size / 2), trunc(x + size - (size * YDIVX / 4)), trunc(y + YDIVX * size / 2));
end; {DrawP}

{******************** DrawQ ****************************}

procedure Font1Procs.DrawQ;

begin
     setcolor(color);
     arc(trunc(x + size / 2), trunc(y + size / 2), 0, 180, trunc(size / 2));
     arc(trunc(x + size / 2), trunc(y + size * YDIVX - size / 2), 180, 360, trunc(size / 2));
     line(x, y + size div 2, x, trunc(y + size * YDIVX - size / 2));
     line(x + size, y + size div 2, x + size, trunc(y + size * YDIVX - size / 2));
     line(trunc(x + size / 2), trunc(y + size * YDIVX - size / 2), x + size, trunc(y + size * YDIVX));
end; {DrawQ}

{******************** DrawR **************************}

procedure Font1Procs.DrawR;

begin
     setcolor(color);
     arc(trunc(x + size - (size * YDIVX / 4)), trunc(y + (size * YDIVX / 4)), 270, 90, trunc(size * YDIVX / 4));
     line(x, y, x, trunc(y + size * YDIVX));
     line(x, y, trunc(x + size - (size * YDIVX / 4)), y);
     line(x, trunc(y + YDIVX * size / 2), trunc(x + size - (size * YDIVX / 4)), trunc(y + YDIVX * size / 2));
     line(x, trunc(y + size * YDIVX / 2), x + size, trunc(y + size * YDIVX));
end; {DrawR}

{*********************** DrawS **************************}

procedure Font1Procs.DrawS;

begin
     setcolor(color);
     ellipse(x + size div 2, trunc(y + size * YDIVX / 4), 0, 270, size div 2, trunc(size * YDIVX / 4));
     ellipse(x + size div 2, trunc(y + size * 3 * YDIVX / 4), 180, 90, size div 2, trunc(size * YDIVX / 4));
end; {DrawS}

{*********************** DrawT **************************}

procedure Font1Procs.DrawT;

begin
     setcolor(color);
     line(x, y, x + size, y);
     line(x + size div 2, y, x + size div 2, trunc(y + size * YDIVX));
end; {DrawT}

{*********************** DrawU **************************}

procedure Font1Procs.DrawU;

begin
     setcolor(color);
     arc(trunc(x + size / 2), trunc(y + size * YDIVX - size / 2), 180, 360, trunc(size / 2));
     line(x + size, y, x + size, trunc(y + size * YDIVX - size / 2));
     line(x, y, x, trunc(y + size * YDIVX - size / 2));
end; {DrawU}

{*********************** DrawV ***************************}

procedure Font1Procs.DrawV;

begin
     setcolor(color);
     line(x, y, x + size div 2, trunc(y + size * YDIVX));
     line(x + size, y, x + size div 2, trunc(y + size * YDIVX));
end; {DrawV}

{*************************** DrawW ************************}

procedure Font1Procs.DrawW;

begin
     setcolor(color);
     line(x, y, x + size div 4, trunc(y + size * YDIVX));
     line(x + size, y, x + 3 * size div 4, trunc(y + size * YDIVX));
     line(x + size div 2, trunc(y + size * YDIVX / 2), x + size div 4, trunc(y + size * YDIVX));
     line(x + size div 2, trunc(y + size * YDIVX / 2), x + 3 * size div 4, trunc(y + size * YDIVX));
end; {DrawW}

{*********************** DrawX **************************}

procedure Font1Procs.DrawX;

begin
     setcolor(color);
     line(x, y, x + size, trunc(y + size * YDIVX));
     line(x, trunc(y + size * YDIVX), x + size, y);
end; {DrawX}

{*********************** DrawY *************************}

procedure Font1Procs.DrawY;

begin
     setcolor(color);
     arc(trunc(x + size / 2), trunc(y + size * YDIVX / 2 - size / 2), 180, 0, size div 2);
     line(trunc(x + size / 2), trunc(y + size * YDIVX / 2), x + size div 2, trunc(y + size * YDIVX));
     line(x, y, x, trunc(y + size * YDIVX / 2 - size / 2));
     line(x + size, y, x + size, trunc(y + size * YDIVX / 2 - size / 2));
end; {DrawY}

{************************** DrawZ ****************************}

procedure Font1Procs.DrawZ;

begin
     setcolor(color);
     line(x, y, x + size, y);
     line(x, trunc(y + size * YDIVX), x + size, trunc(y + size * YDIVX));
     line(x + size, y, x, trunc(y + size * YDIVX));
end; {DrawZ}

{<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
            CHARACTER DRAWING ROUTINES STOP HERE
>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>}

{***************************** Init Graph Letts ***************************}

procedure Font1Procs.InitGraphLetts;
{init procedure for object}

var ErCd, GrMd, GrDr : integer;   {3 vars used to install BGI drivers}

    procedure Abort(Msg : string);  {quits}

    begin
         Writeln(Msg, ': ', GraphErrorMsg(GraphResult));
         Halt(1);          {Shows message and quits with a DOS exit code of 1}
    end;

begin
     {Registers all the drivers}
     if RegisterBGIdriver(@CGADriverProc) < 0 then
        Abort('CGA');
     if RegisterBGIdriver(@EGAVGADriverProc) < 0 then
        Abort('EGA/VGA');
     if RegisterBGIdriver(@HercDriverProc) < 0 then
        Abort('Herc');
     if RegisterBGIdriver(@ATTDriverProc) < 0 then
        Abort('AT&T');
     if RegisterBGIdriver(@PC3270DriverProc) < 0 then
        Abort('PC 3270');


     {Registers all the fonts}
     if RegisterBGIfont(@GothicFontProc) < 0 then
        Abort('Gothic');
     if RegisterBGIfont(@SansSerifFontProc) < 0 then
        Abort('SansSerif');
     if RegisterBGIfont(@SmallFontProc) < 0 then
        Abort('Small');
     if RegisterBGIfont(@TriplexFontProc) < 0 then
        Abort('Triplex');

     GrDr := Detect;                  {autodetects the hardware}
     InitGraph(GrDr, GrMd, '');  {activates graphics}
     ErCd := GraphResult;        {finds the error code(s)}
     if ErCd <> GrOK then begin      {if there are any errors...}
        writeln('Graphics error: ', GraphErrorMsg(ErCd));
        writeln('Press ENTER...');
        writeln('Exiting...');    {Outputs message and quits}
        readln;
        halt;
     end; {if}

     YDIVX := YDX;      {sets all private vars. to the values passed}
     tablength := tabl;
     alarmbellfrequency := abf;
     alarmbelltime := abt;

     movetextcursor(2, 2);   {moves text cursor to (2, 2)}
     SetCurrColor(12);       {sets text color to light red}
     SetCurrSize(10);        {sets text size to 10 pixels wide}

end; {Initletters}

{************************ MoveTextCursor *************************}

procedure Font1Procs.movetextcursor;
{moves text cursor to the values passed}

begin
     textcursorx := x;   {sets private vars. to the passed values}
     textcursory := y;
end;

{************************* GetTextcursorXY *****************************}

procedure Font1Procs.GetTextCursorXY;
{returns the values of the private vars. of the text position}

begin
     x := textcursorx; {Assigns the vals. of the var. params. to the values}
     y := textcursory; { of the private vars.}
end;

{***************************** Set Current Size *****************************}

procedure Font1Procs.SetCurrSize;
{sets the value of the private var. size to the value passed}

begin
     CurrentSize := size; {assigns the value of the private var. to the passed value}
end;

{********************** Set Current Color ************************}

procedure Font1Procs.SetCurrColor;
{sets the value of the private var. color to the value passed}

begin
     CurrentColor := color; {assigns the value of the private var. to the passed value}
end;

{*************************** Get Current Size ***************************}

procedure Font1Procs.GetCurrSize;
{returns the value of the private var. size}

begin
     size := CurrentSize; {assigns the value of the var. param. to the value of the private var.}
end;

{************************ Get Current Color ****************************}

procedure Font1Procs.GetCurrColor;
{returns the text color in the var. param}

begin
     color := CurrentColor; {sets the value of the var. param. to the value of the private var.}
end;

{******************************** Destruct *********************************}

procedure Font1Procs.Destruct;
{cleans up after using the font.  Always call this procedure at the end of the program}

begin
     closegraph;         {exits graphics mode}
     textcolor(15);      {sets normal text color to bright white}
     textbackground(0);  {sets normal text background to black}
end;


{************************** Ps Printf ******************************}

procedure Font1Procs.psprintf;
{writes a string of characters to the screen.  Pass it a null terminated string}

var ctr, ctr1 : integer;   {loop counters}
    xpos, ypos : integer;  {position counters}
    backslash : boolean;   {backslash boolean flag}
    quote : boolean;       {quote boolean flag}
    size, color : word;    {size & color vars}

begin
     ctr := 1;             {inits counter to 1}
     if ((x >= 0) and (y >= 0)) then begin
        xpos := x;            {if new vals. are passed...}
        ypos := y;
     end {if}
     else begin        {if neg. vals. are passed, then private vals. are used}
         GetTextCursorXY(xpos, ypos);
         GetTextCursorXY(x, y);
     end; {else}
     if (col < 0) then      {if neg. vals. are passed, then private vals. are used}
        GetCurrColor(color)
     else            {if new vals. are passed...}
         color := col;
     if (siz >= 0) then  {if new vals are passed...}
        size := siz
     else              {if neg. vals. are passed, then private vals. are used}
         GetCurrSize(size);
     backslash := false;   {inits. backslash boolean flag to false}
     quote := false;       {inits. quote boolean flag to false}
     while chrstr[ctr] in [#32..#126] do begin {Checks if char. is valid}
           case UpCase(chrstr[ctr]) of       {Branches based on val. of char.  Draws the appropriate char.}
                'A' : if backslash then begin
                         sound(ALARMBELLFREQUENCY);
                         delay(ALARMBELLTIME);
                         nosound;
                         xpos := xpos - size - size div 3 - 1;
                         backslash := false;
                      end
                      else
                          DrawA(xpos, ypos, size, color);
                'B' : DrawB(xpos, ypos, size, color);
                'C' : DrawC(xpos, ypos, size, color);
                'D' : DrawD(xpos, ypos, size, color);
                'E' : DrawE(xpos, ypos, size, color);
                'F' : DrawF(xpos, ypos, size, color);
                'G' : DrawG(xpos, ypos, size, color);
                'H' : DrawH(xpos, ypos, size, color);
                'I' : DrawI(xpos, ypos, size, color);
                'J' : DrawJ(xpos, ypos, size, color);
                'K' : DrawK(xpos, ypos, size, color);
                'L' : DrawL(xpos, ypos, size, color);
                'M' : DrawM(xpos, ypos, size, color);
                'N' : if backslash then begin
                         ypos := ypos + trunc(size * YDIVX) + size div 2 + 1;
                         xpos := xpos - size - size div 3 - 1;
                         backslash := false;
                      end
                      else
                          DrawN(xpos, ypos, size, color);
                'O' : DrawO(xpos, ypos, size, color);
                'P' : DrawP(xpos, ypos, size, color);
                'Q' : DrawQ(xpos, ypos, size, color);
                'R' : if backslash then begin
                         ypos := ypos + trunc(size * YDIVX) + size div 2 + 1;
                         xpos := x mod (size + size div 3 + 1) - size - size div 3 - 1;
                         backslash := false;
                      end
                      else
                          DrawR(xpos, ypos, size, color);
                'S' : DrawS(xpos, ypos, size, color);
                'T' : if backslash then begin
                         xpos := xpos + (size + size div 3 + 1) * (TABLENGTH - 1);
                         backslash := false;
                      end
                      else
                          DrawT(xpos, ypos, size, color);
                'U' : DrawU(xpos, ypos, size, color);
                'V' : DrawV(xpos, ypos, size, color);
                'W' : DrawW(xpos, ypos, size, color);
                'X' : DrawX(xpos, ypos, size, color);
                'Y' : DrawY(xpos, ypos, size, color);
                'Z' : DrawZ(xpos, ypos, size, color);
                '0' : Draw0(xpos, ypos, size, color);
                '1' : Draw1(xpos, ypos, size, color);
                '2' : Draw2(xpos, ypos, size, color);
                '3' : Draw3(xpos, ypos, size, color);
                '4' : Draw4(xpos, ypos, size, color);
                '5' : Draw5(xpos, ypos, size, color);
                '6' : Draw6(xpos, ypos, size, color);
                '7' : Draw7(xpos, ypos, size, color);
                '8' : Draw8(xpos, ypos, size, color);
                '9' : Draw9(xpos, ypos, size, color);
                ' ' : DrawSPC(xpos, ypos, size, color);
                '!' : DrawEXC(xpos, ypos, size, color);
                '#' : DrawNUM(xpos, ypos, size, color);
                '?' : DrawQUES(xpos, ypos, size, color);
                '$' : DrawDLR(xpos, ypos, size, color);
                '%' : if backslash then begin
                         DrawPRC(xpos, ypos, size, color);
                         backslash := false;
                      end;
                '(' : DrawOPR(xpos, ypos, size, color);
                ')' : DrawCPR(xpos, ypos, size, color);
                '*' : if backslash then begin
                         DrawTIMES(xpos, ypos, size, color);
                         backslash := false;
                      end
                      else
                          DrawAST(xpos, ypos, size, color);
                '"' : begin
                      if backslash then begin
                         quote := false;
                         xpos := xpos - size - size div 3 - 1;
                         backslash := false;
                      end
                      else
                          case quote of
                           false : begin
                                        DrawODBQT(xpos, ypos, size, color);
                                        quote := true;
                                   end;
                           true  : begin
                                        DrawCDBQT(xpos, ypos, size, color);
                                        quote := false;
                                   end;
                          end;
                      end;
                '''' : DrawCSIQT(xpos, ypos, size, color);
                '`' : DrawOSIQT(xpos, ypos, size, color);
                '+' : DrawPLS(xpos, ypos, size, color);
                ',' : DrawCMA(xpos, ypos, size, color);
                '-' : DrawMNS(xpos, ypos, size, color);
                '.' : DrawPRD(xpos, ypos, size, color);
                '/' : if backslash then begin
                         DrawDIV(xpos, ypos, size, color);
                         backslash := false;
                      end
                      else
                          DrawSLSH(xpos, ypos, size, color);
                ':' : DrawCLN(xpos, ypos, size, color);
                ';' : DrawSMICLN(xpos, ypos, size, color);
                '<' : if backslash then
                         DrawLESOREQ(xpos, ypos, size, color)
                      else
                         DrawLES(xpos, ypos, size, color);
                '>' : if backslash then
                         DrawGREOREQ(xpos, ypos, size, color)
                      else
                          DrawGRE(xpos, ypos, size, color);
                '=' : if backslash then
                         DrawAPPROX(xpos, ypos, size, color)
                      else
                          DrawEQU(xpos, ypos, size, color);
                '~' : if backslash then
                         DrawTIL(xpos, ypos, size, color)
                      else
                          DrawSIM(xpos, ypos, size, color);
                '[' : DrawOBR(xpos, ypos, size, color);
                ']' : DrawCBR(xpos, ypos, size, color);
                '{' : DrawOBRACE(xpos, ypos, size, color);
                '}' : DrawCBRACE(xpos, ypos, size, color);
                '^' : DrawCAR(xpos, ypos, size, color);
                '_' : DrawUND(xpos, ypos, size, color);
                '\' : if backslash then begin
                         DrawBSH(xpos, ypos, size, color);
                         backslash := false;
                      end
                      else begin
                          backslash := true;
                          xpos := xpos - size - size div 3 - 1;
                      end;
           end; {case}
           xpos := xpos + size + size div 3 + 1; {increments x position by appropriate value}
           if xpos > GetMaxX - size then begin  {carriage return if the string exceeds the length of the screen}
              xpos := x mod (size + size div 3 + 1);
              ypos := ypos + trunc(size * YDIVX) + size div 2 + 1;
           end; {if}
           ctr := ctr + 1;  {increments counter by 1}
     end; {while}
     for ctr1 := 1 to (ctr + 1) do  {clears whole string}
         chrstr[ctr1] := #0;

     movetextcursor(xpos, ypos);  {refreshes private vars.}
     SetCurrColor(color);
     SetCurrSize(size);

end;

{***************** Flash Paragraph *********************}

procedure font1procs.psflashpara;
{Outputs a paragraph in 'Mission Impossible' font}

var xpos, ypos : integer;   {position counters}
    ctr1, ctr2 : integer;   {loop counters}

begin
     xpos := x;   {sets position counters to the values passed}
     ypos := y;
     for ctr1 := 1 to rows do begin  {Draws the specified num. of lines}
         for ctr2 := 1 to cols do begin {Draws an entire line}
             if ctr2 > 1 then begin     {If the char isn't at the start...}
                psprintf(xpos, ypos, siz, col+8, 1, para[ctr1][ctr2]+#0); {draws the char}
                delay(delaytime);           {pauses for the specified amount of time}
                psprintf(xpos - xin, ypos, siz, col, 1, para[ctr1][ctr2-1]+#0) {draws the char right before the former char.}
             end  {if}
             else begin
                  psprintf(xpos, ypos, siz, col + 8, 1, para[ctr1][ctr2]+#0); {draws the char}
                  delay(trunc(delaytime*5/3));   {pauses for the specified amount of time X 5/3}
                  psprintf(xpos, ypos, siz, col, 1, para[ctr1][ctr2]+#0)  {draws the char again}
             end; {else}
             xpos := xpos + xin {Increments the x position by the specified amount}
         end; {for}
         psprintf(xpos - xin, ypos, siz, col, 1, para[ctr1][ctr2]+#0); {draws the last character again}
         xpos := x;  {carriage return to original column}
         ypos := ypos + yin  {y position is incremented by specified amount}
     end;  {for}
end;


{************************* Ps Scanf *************************}

function Font1Procs.psscanf;
{reads in values}

var int : integer;
    stringvar : string;
    realnum : real;
    longnum : longint;
    integerreturn : integer absolute ptr;  {Open parameters need absolute}
    stringreturn : string absolute ptr;    { vars.}
    realreturn : real absolute ptr;
    longreturn : longint absolute ptr;

{====================== Ps Scan Int ================================}

function psscanint(var integertpnum : integer) : byte;
{reads in an integer}

var number : integer;       {total}
    digit : char;           {current digit entered}
    plusorminus : shortint; {flag}

begin
     psscanint := 0;    {assigns 'no error' to the return value}
     digit := ReadKey;  {assigns digit to the key just read}
     number := 0;       {sets the total to 0}
     plusorminus := 1;  {sets flag to positive}
     case digit of      {checks if digit is a sign}
          #45 : begin                     {'-' sign...}
                plusorminus := -1;        {sets flag to negative}
                psprintf(-1, -1, -1, -1, 1, digit);  {writes char. on screen}
                digit := ReadKey;          {reads in a new value for digit}
                end;
          #43 : begin                  {'+' sign...}
                plusorminus := 1;        {sets flag to positive}
                psprintf(-1, -1, -1, -1, 1, digit); {echoes char. on screen}
                digit := ReadKey;             {reads in a new value for digit}
                end;
     end; {case}
     while (digit in [#48..#57]) do begin  {repeats until the digit is non-numeric}
           if ((number > 3276) or (number < -3276)) then begin {if the total overflows}
              integertpnum := 0;       {sets return val. to 0}
              psscanint := 1;        {returns error code to calling module}
              exit;                {exits out of procedure}
           end  {if}
           else begin
                number := number * 10 + plusorminus * (ord(digit) - ord('0'));  {adds the digit to the total}
                psprintf(-1, -1, -1, -1, 1, digit);   {echoes char. on screen}
                digit := ReadKey;    {reads in new value for digit}
           end  {else}
     end; {while}

     integertpnum := plusorminus * number; {returns the number to the calling module}

end;

{======================== Ps Scan Long ===================================}

function psscanlong(var longtpnum : longint) : byte;
{reads in a long integer}

var number : longint;       {total}
    digit : char;           {current digit}
    plusorminus : shortint; {sign flag}

begin
     digit := ReadKey;      {reads in a char. and puts it in the curr. digit}
     number := 0;           {inits. total to 0}
     plusorminus := 1;      {sets sign flag to positive}
     case digit of          {checks if digit is a sign}
          #45 : begin       {if it is '-'...}
                plusorminus := -1;        {sets sign flag to negative}
                psprintf(-1, -1, -1, -1, 1, digit); {echoes char. on screen}
                digit := ReadKey;         {reads in new val. for curr. char.}
                end;
          #43 : begin         {if it is '+'...}
                plusorminus := 1;     {sets sign flag to positive}
                psprintf(-1, -1, -1, -1, 1, digit); {echoes char. on screen}
                digit := ReadKey;      {reads in new val. for curr. char.}
                end;
          else ;      {otherwise, do nothing}
     end; {case}
     while (digit in [#48..#57]) do begin {repeat while char. is a digit}
           if ((number > 214748364) or (number < -214748364)) then begin
              longtpnum := 0; {returns a 0}                    {overflow}
              psscanlong := 1; {sets error code to error}
              exit;     {returns to calling module}
           end  {if}
           else begin
                number := number * 10 + ord(digit) - ord('0'); {adds char. to total}
                psprintf(-1, -1, -1, -1, 1, digit); {echoes char. on screen}
                digit := ReadKey;  {reads in new val. for curr. char.}
           end;  {else}
     end; {while}

     psscanlong := 0;   {sets error code to none}
     longtpnum := plusorminus * number;  {returns the total to calling module}

end;

{============================== Ps Scan Str ================================}

function psscanstr(var strtpnum : string) : byte;
{inputs a string}

var stringtoret : string; {string total}
    len : word;           {length counter}
    letter : char;        {current letter}

begin
     stringtoret[0] := #0;   {inits. total to 0}
     letter := ReadKey;      {reads in char. for curr. letter}
     len := 0;               {inits. length counter to 0}
     while letter in [#32..#126] do begin  {repeats until char. isn't valid}
           if (len < 255) then begin  {no overflow...}
              if (letter = '\') then  {if the char. is a '\'}
                 psprintf(-1, -1, -1, -1, 1, '\\');  {echoes '\' on screen}
              psprintf(-1, -1, -1, -1, 1, letter);   {echoes it on screen}
              len := len + 1;         {increments length counter by one}
              stringtoret[len] := Upcase(letter); {adds char. to total}
              letter := ReadKey;
           end  {if}
           else begin  {overflow!}
               psscanstr := 1;  {sets error code to error}
               psprintf(-1, -1, -1, -1, 1, 'OVERFLOW ERROR!'); {outputs 'overflow error!'}
               exit; {returns to calling module}
           end; {else}
     end; {while}
     psscanstr := 0;      {sets error code to no error}
     stringtoret[0] := chr(len);  {sets index 0 to string len.}
     stringtoret[len + 1] := #0;  {terminates with a null zero}
     strtpnum := stringtoret;     {returns the inputted string}

end;

{======================== Ps Scan Real ==============================}

function psscanreal(var realtpnum : real) : byte;
{reads in a real number}

var realtoreturn : real;     {total}
    stringreal : string;     {real in string form}
    errcd : integer;         {error flag}

begin
     realtpnum := 0;       {sets total to 0}
     psscanstr(stringreal);  {reads in the real as a string}
     Val(stringreal, realtoreturn, errcd);{converts the string back to a real}
     if (errcd <> 0) then    {if there is an error...}
        psscanreal := errcd      {sets error code to error}
     else                {No error!}
         psscanreal := 0;   {sets error code to no error}
     realtpnum := realtoreturn;  {returns the real number total}
end;

{++++++++++++++++++++++++++++ Ps Scanf Main ++++++++++++++++++++++++++++++++}

begin
     psscanf := 0;   {sets error code to no error}
     case scantype[2] of   {determines which data type will be inputted}
          'l' : begin
                if (psscanlong(longnum) = 1) then {if there was an error...}
                   psscanf := 1     {sets error code to error}
                else    {No error!}
                    longreturn := longnum; {returns the value}
                end;  {if-else}
          'd' : begin
                if (psscanint(int) = 1) then {if there was an error...}
                   psscanf := 1 {sets error code to error}
                else   {No error!}
                    integerreturn := int;   {returns the value}
                end;  {if-else}
          'r' : begin
                if (psscanreal(realnum) = 1) then  {if there was an error...}
                   psscanf := 1  {sets error code to error}
                else  {No error!}
                    realreturn := realnum;   {returns the value}
                end; {if-else}
          's' : begin
                if (psscanstr(stringvar) = 1) then {if there was an error...}
                   psscanf := 1   {sets error code to error}
                else   {No error!}
                    stringreturn := stringvar;  {returns the value}
                end; {if-else}
     end; {case}
end;

{~~~~~~~~~~~~~~~~~~~~~~~~ End of Font1Procs ~~~~~~~~~~~~~~~~~~~~~~~}

{~~~~~~~~~~~~~~~~~~~~~~~ Conversion Routines ~~~~~~~~~~~~~~~~~~~~~}

{********************** Converts Longs To Strings ************************}

function LongToString(longtostrnum : longint) : string;

var ctr, len : byte;   {position counter and length counter}
    stringtoreturn : string; {return string}
    longtmp : longint; {temp. long}
    plus : boolean;    {sign flag}

begin
     if (longtostrnum >= 0) then begin {if it is positive...}
        plus := true;  {sets sign flag to positive}
        ctr := 0       {sets position counter to 0}
     end  {if}
     else begin
         plus := false; {sets sign flag to negative}
         ctr := 1;      {sets position counter to 1}
     end;  {else}
     longtmp := longtostrnum; {sets temp. long to the passed value}
     while (longtmp <> 0) do begin  {while the temp. long is not 0}
           ctr := ctr + 1; {increments counter}
           longtmp := (longtmp - longtmp mod 10) div 10; {adds current digit to return string}
     end; {while}
     len := ctr;   {sets length counter to the position counter}
     longtmp := longtostrnum; {sets temp. long to the passed value}
     if plus then  {if it is positive...}
        for ctr := len downto 1 do begin   {places the digits in the string}
            stringtoreturn[ctr] := chr(longtmp mod 10 + 48);
            longtmp := (longtmp - longtmp mod 10) div 10;
        end {for}
     else begin
         stringtoreturn[1] := '-';   {puts a '-' in the front of the string}
         for ctr := len downto 2 do begin    {places the digits in the string}
            stringtoreturn[ctr] := chr(48 - (longtmp mod 10));
            longtmp := (longtmp - longtmp mod 10) div 10;
         end; {for}
     end;  {else}
     stringtoreturn[0] := chr(len);  {places the length in the first location}
     stringtoreturn[len + 1] := #0;  {terminates with a null character}
     LongToString := stringtoreturn; {places the string in the return value}
end;

{***************** Converts Integers to Strings ****************}

function IntToString(inttoconvert : integer) : string;

var strtoreturn : string;    {return string total}

begin
     str(inttoconvert, strtoreturn);  {converts integer to string}
     IntToString := strtoreturn;      {returns the string}
end;

end.  {unit}