unit PButV101;

interface

const
     LEFT_BUTTON = 0;
     MIDDLE_BUTTON = 2;
     RIGHT_BUTTON = 1;

type
    _PBut_ListPtr = ^_PBut_ListType;
    _PBut_ListType = record
                     key : string;
                     col : word;
                     xs, ys, xe, ye : integer;
                     down : boolean;
                     prev, next : _PBut_ListPtr
                     end;

    ButtonObject = object

                   public

                   procedure InitPBut;
                   procedure AddButton(xs, ys, xe, ye : integer; col : word; key : string);
                   function RemoveButton(key : string) : boolean;
                   procedure ShowAllButtons;
                   function TrapClick(ButNum : integer) : string;
                   function CheckLastClick : string;
                   procedure SetShadowLength(s : integer);
                   procedure SetRadiusLength(r : integer);
                   procedure Destruct;

                   private

                   ButtonList : _PBut_ListPtr;
                   S_L : integer;
                   R_L : integer;

                   end;

implementation

uses
    graph, DOS;

procedure ButtonObject.InitPBut;

var
   regs : registers;

begin
     new(ButtonList);
     with ButtonList^ do
          begin
               xs := 0;
               ys := 0;
               xe := 0;
               ye := 0;
               next := ButtonList;
               prev := ButtonList;
               col := 0;
               key := ' ';
               down := false
          end;
     S_L := 2;
     R_L := 2;
     regs.ax := $000D;
     intr($33, regs)
end;

procedure ButtonObject.AddButton;

var
   cur1, cur2 : _PBut_ListPtr;

begin
     cur1 := ButtonList;
     while cur1^.next <> ButtonList do
           cur1 := cur1^.next;
     new(cur2);
     cur2^.prev := cur1;
     cur1^.next := cur2;
     cur2^.xs := xs;
     cur2^.ys := ys;
     cur2^.xe := xe;
     cur2^.ye := ye;
     cur2^.key := key;
     cur2^.col := col;
     cur2^.down := false;
     cur2^.next := ButtonList
end;

function ButtonObject.RemoveButton;

var
   cur, del : _PBut_ListPtr;

begin
     cur := ButtonList^.next;
     while (cur^.key <> key) and (cur <> ButtonList) do
           cur := cur^.next;
     if cur^.key = key then
        begin
             RemoveButton := true;
             del := cur;
             cur := cur^.prev;
             cur^.next := cur^.next^.next;
             cur^.next^.prev := cur;
             dispose(del)
        end
     else
         RemoveButton := false
end;

procedure ButtonObject.ShowAllButtons;

var
   cur : _PBut_ListPtr;

   procedure DrawButton(BDat : _PBut_ListType; On : boolean);

   begin
        if not(On) then
           begin
                BDat.xs := BDat.xs + S_L;
                BDat.xe := BDat.xe + S_L;
                BDat.ys := BDat.ys + S_L;
                BDat.ye := BDat.ye + S_L;
                setfillstyle(SolidFill, BDat.col);
                setcolor(BDat.col);
                PieSlice(BDat.xs + R_L, BDat.ys + R_L, 90, 180, R_L);
                PieSlice(BDat.xs + R_L, BDat.ye - R_L, 180, 270, R_L);
                PieSlice(BDat.xe - R_L, BDat.ys + R_L, 0, 90, R_L);
                PieSlice(BDat.xe - R_L, BDat.ye - R_L, 270, 360, R_L);
                bar(BDat.xs, BDat.ys + R_L, BDat.xe, BDat.ye - R_L);
                bar(BDat.xs + R_L, BDat.ys, BDat.xe - R_L, BDat.ye);
                BDat.xs := BDat.xs - S_L;
                BDat.xe := BDat.xe - S_L;
                BDat.ys := BDat.ys - S_L;
                BDat.ye := BDat.ye - S_L;
                setfillstyle(SolidFill, BDat.col + 8);
                setcolor(BDat.col + 8);
                PieSlice(BDat.xs + R_L, BDat.ys + R_L, 90, 180, R_L);
                PieSlice(BDat.xs + R_L, BDat.ye - R_L, 180, 270, R_L);
                PieSlice(BDat.xe - R_L, BDat.ys + R_L, 0, 90, R_L);
                PieSlice(BDat.xe - R_L, BDat.ye - R_L, 270, 360, R_L);
                bar(BDat.xs, BDat.ys + R_L, BDat.xe, BDat.ye - R_L);
                bar(BDat.xs + R_L, BDat.ys, BDat.xe - R_L, BDat.ye)
           end
        else begin
             BDat.xs := BDat.xs;
             BDat.xe := BDat.xe;
             BDat.ys := BDat.ys;
             BDat.ye := BDat.ye;
             setfillstyle(SolidFill, Black);
             SetColor(Black);
             PieSlice(BDat.xs + R_L, BDat.ys + R_L, 90, 180, R_L);
             PieSlice(BDat.xs + R_L, BDat.ye - R_L, 180, 270, R_L);
             PieSlice(BDat.xe - R_L, BDat.ys + R_L, 0, 90, R_L);
             PieSlice(BDat.xe - R_L, BDat.ye - R_L, 270, 360, R_L);
             bar(BDat.xs, BDat.ys + R_L, BDat.xe, BDat.ye - R_L);
             bar(BDat.xs + R_L, BDat.ys, BDat.xe - R_L, BDat.ye);
             BDat.xs := BDat.xs + S_L;
             BDat.xe := BDat.xe + S_L;
             BDat.ys := BDat.ys + S_L;
             BDat.ye := BDat.ye + S_L;
             setfillstyle(SolidFill, BDat.col + 8);
             setcolor(BDat.col + 8);
             PieSlice(BDat.xs + R_L, BDat.ys + R_L, 90, 180, R_L);
             PieSlice(BDat.xs + R_L, BDat.ye - R_L, 180, 270, R_L);
             PieSlice(BDat.xe - R_L, BDat.ys + R_L, 0, 90, R_L);
             PieSlice(BDat.xe - R_L, BDat.ye - R_L, 270, 360, R_L);
             bar(BDat.xs, BDat.ys + R_L, BDat.xe, BDat.ye - R_L);
             bar(BDat.xs + R_L, BDat.ys, BDat.xe - R_L, BDat.ye)
        end
   end;

begin
     cur := ButtonList^.next;
     while cur <> ButtonList do
           begin
                DrawButton(cur^, false);
                cur := cur^.next
           end
end;

function ButtonObject.TrapClick;

var
   xpos, ypos, xpos2, ypos2 : integer;
   cur : _PBut_ListPtr;
   regs : registers;
   picked : boolean;

   function ButtonPressed(BNum : integer; BData : integer) : boolean;

   begin
        case BNum of
             LEFT_BUTTON : ButtonPressed := BData mod 2 = 1;
             RIGHT_BUTTON : ButtonPressed := BData div 2 mod 2 = 1;
             MIDDLE_BUTTON : ButtonPressed := BData div 4 = 1
        end
   end;

   procedure DrawButton(BDat : _PBut_ListType; On : boolean);

   begin
        if not(On) then
           begin
                BDat.xs := BDat.xs + S_L;
                BDat.xe := BDat.xe + S_L;
                BDat.ys := BDat.ys + S_L;
                BDat.ye := BDat.ye + S_L;
                setfillstyle(SolidFill, BDat.col);
                setcolor(BDat.col);
                PieSlice(BDat.xs + R_L, BDat.ys + R_L, 90, 180, R_L);
                PieSlice(BDat.xs + R_L, BDat.ye - R_L, 180, 270, R_L);
                PieSlice(BDat.xe - R_L, BDat.ys + R_L, 0, 90, R_L);
                PieSlice(BDat.xe - R_L, BDat.ye - R_L, 270, 360, R_L);
                bar(BDat.xs, BDat.ys + R_L, BDat.xe, BDat.ye - R_L);
                bar(BDat.xs + R_L, BDat.ys, BDat.xe - R_L, BDat.ye);
                BDat.xs := BDat.xs - S_L;
                BDat.xe := BDat.xe - S_L;
                BDat.ys := BDat.ys - S_L;
                BDat.ye := BDat.ye - S_L;
                setfillstyle(SolidFill, BDat.col + 8);
                setcolor(BDat.col + 8);
                PieSlice(BDat.xs + R_L, BDat.ys + R_L, 90, 180, R_L);
                PieSlice(BDat.xs + R_L, BDat.ye - R_L, 180, 270, R_L);
                PieSlice(BDat.xe - R_L, BDat.ys + R_L, 0, 90, R_L);
                PieSlice(BDat.xe - R_L, BDat.ye - R_L, 270, 360, R_L);
                bar(BDat.xs, BDat.ys + R_L, BDat.xe, BDat.ye - R_L);
                bar(BDat.xs + R_L, BDat.ys, BDat.xe - R_L, BDat.ye)
           end
        else begin
             BDat.xs := BDat.xs;
             BDat.xe := BDat.xe;
             BDat.ys := BDat.ys;
             BDat.ye := BDat.ye;
             setfillstyle(SolidFill, Black);
             setcolor(Black);
             PieSlice(BDat.xs + R_L, BDat.ys + R_L, 90, 180, R_L);
             PieSlice(BDat.xs + R_L, BDat.ye - R_L, 180, 270, R_L);
             PieSlice(BDat.xe - R_L, BDat.ys + R_L, 0, 90, R_L);
             PieSlice(BDat.xe - R_L, BDat.ye - R_L, 270, 360, R_L);
             bar(BDat.xs, BDat.ys + R_L, BDat.xe, BDat.ye - R_L);
             bar(BDat.xs + R_L, BDat.ys, BDat.xe - R_L, BDat.ye);
             BDat.xs := BDat.xs + S_L;
             BDat.xe := BDat.xe + S_L;
             BDat.ys := BDat.ys + S_L;
             BDat.ye := BDat.ye + S_L;
             setfillstyle(SolidFill, BDat.col + 8);
             setcolor(BDat.col + 8);
             PieSlice(BDat.xs + R_L, BDat.ys + R_L, 90, 180, R_L);
             PieSlice(BDat.xs + R_L, BDat.ye - R_L, 180, 270, R_L);
             PieSlice(BDat.xe - R_L, BDat.ys + R_L, 0, 90, R_L);
             PieSlice(BDat.xe - R_L, BDat.ye - R_L, 270, 360, R_L);
             bar(BDat.xs, BDat.ys + R_L, BDat.xe, BDat.ye - R_L);
             bar(BDat.xs + R_L, BDat.ys, BDat.xe - R_L, BDat.ye)
        end
   end;

   function OnButton(x, y : integer; BDat : _PBut_ListType) : boolean;

   begin
        if (x >= BDat.xs) and (x <= BDat.xe) and (y >= BDat.ys) and (y <= BDat.ye) then
           begin
                if (x >= BDat.xs) and (y >= BDat.ys) and (x <= BDat.xs + R_L) and (y <= BDat.ys + R_L) then
                   if sqrt(sqr(x - BDat.xs) + sqr(y - BDat.ys)) <= R_L then
                      OnButton := true
                   else
                       OnButton := false
                else if (x >= BDat.xs) and (y <= BDat.ye) and (x <= BDat.xs - R_L) and (y >= BDat.ye - R_L) then
                     if sqrt(sqr(x - BDat.xs) + sqr(y - BDat.ye)) <= R_L then
                        OnButton := true
                     else
                         OnButton := false
                else if (x <= BDat.xe) and (x >= BDat.xe - R_L) and (y >= BDat.ys) and (y <= BDat.ys + R_L) then
                     if sqrt(sqr(x - BDat.xe) + sqr(y - BDat.ys)) <= R_L then
                        OnButton := true
                     else
                         OnButton := false
                else if (x <= BDat.xe) and (x >= BDat.xe - R_L) and (y <= BDat.ye) and (y >= BDat.ye - R_L) then
                     if sqrt(sqr(x - BDat.xe) + sqr(y - BDat.ye)) <= R_L then
                        OnButton := true
                     else
                         OnButton := false
                else
                    OnButton := true
           end
        else
            OnButton := false
   end;


begin
     xpos := -1;
     ypos := -1;
     picked := false;
     repeat
           regs.ax := $0005;
           regs.bx := ButNum;
           intr($33, regs);
           xpos := regs.cx;
           ypos := regs.dx;
           cur := ButtonList^.next;
           while (cur <> ButtonList) and not(picked) do
                 begin
                      if {(xpos >= cur^.xs) and (xpos <= cur^.xe) and
                         (ypos >= cur^.ys) and (ypos <= cur^.ye)} OnButton(xpos, ypos, cur^) then
                               begin
                                    regs.ax := $0003;
                                    intr($33, regs);
                                    if {(regs.cx >= cur^.xs) and (regs.cx <= cur^.xe) and (regs.dx >= cur^.ys) and
           (regs.dx <= cur^.ye)} OnButton(regs.cx, regs.dx, cur^) and ButtonPressed(ButNum, regs.bx) and not(cur^.down) then
                                          begin
                                               xpos2 := regs.cx;
                                               ypos2 := regs.dx;
                                               regs.ax := $0010;
                                               regs.cx := cur^.xs;
                                               regs.ds := cur^.ys;
                                               regs.si := cur^.xe + S_L;
                                               regs.di := cur^.ye + S_L;
                                               intr($33, regs);
                                               {setfillstyle(SolidFill, Black);
                                               bar(cur^.xs, cur^.ys, cur^.xe, cur^.ye);
                                               setfillstyle(SolidFill, cur^.col + 8);
                                               bar(cur^.xs + S_L, cur^.ys + S_L, cur^.xe + S_L, cur^.ye + S_L);}
                                               DrawButton(cur^, true);
                                               regs.ax := $0021;
                                               intr($33, regs);
                                               regs.ax := $0004;
                                               regs.cx := xpos2;
                                               regs.dx := ypos2;
                                               intr($33, regs);
                                               regs.ax := $0001;
                                               intr($33, regs);
                                               cur^.down := true
                                          end
                                    else if not({(regs.cx >= cur^.xs) and (regs.cx <= cur^.xe) and (regs.dx >= cur^.ys) and
     (regs.dx <= cur^.ye)} OnButton(regs.cx, regs.dx, cur^) and ButtonPressed(ButNum, regs.bx)) and cur^.down then
                                         begin
                                              xpos2 := regs.cx;
                                              ypos2 := regs.dx;
                                              regs.ax := $0010;
                                              regs.cx := cur^.xs;
                                              regs.ds := cur^.ys;
                                              regs.si := cur^.xe + S_L;
                                              regs.di := cur^.ye + S_L;
                                              intr($33, regs);
                                              {setfillstyle(SolidFill, cur^.col);
                                              bar(cur^.xs + S_L, cur^.ys + S_L, cur^.xe + S_L, cur^.ye + S_L);
                                              setfillstyle(SolidFill, cur^.col + 8);
                                              bar(cur^.xs, cur^.ys, cur^.xe, cur^.ye);}
                                              DrawButton(cur^, false);
                                              regs.ax := $0021;
                                              intr($33, regs);
                                              regs.ax := $0004;
                                              regs.cx := xpos2;
                                              regs.dx := ypos2;
                                              intr($33, regs);
                                              regs.ax := $0001;
                                              intr($33, regs);
                                              cur^.down := false
                                         end;
                                    regs.ax := $0006;
                                    regs.bx := ButNum;
                                    intr($33, regs);
                                    if {(regs.cx >= cur^.xs) and
                                       (regs.cx <= cur^.xe) and
                                       (regs.dx >= cur^.ys) and
                                       (regs.dx <= cur^.ye)}
                                       OnButton(regs.cx, regs.dx, cur^) then
                                                begin
                                                     regs.ax := $0003;
                                                     intr($33, regs);
                                                     case ButNum of
                                                          LEFT_BUTTON : if regs.bx mod 2 = 0 then
                                                                           begin
                                                                                picked := true;
                                                                                TrapClick := cur^.key
                                                                           end;
                                                          RIGHT_BUTTON : if regs.bx div 2 mod 2 = 0 then
                                                                            begin
                                                                                 picked := true;
                                                                                 TrapClick := cur^.key
                                                                            end;
                                                          MIDDLE_BUTTON : if regs.bx div 4 = 1 then
                                                                             begin
                                                                                  picked := true;
                                                                                  TrapClick := cur^.key
                                                                             end
                                                     end
                                                end
                               end
                      else begin
                           if cur^.down then
                              begin
                                   xpos2 := regs.cx;
                                   ypos2 := regs.dx;
                                   regs.ax := $0010;
                                   regs.cx := cur^.xs;
                                   regs.ds := cur^.ys;
                                   regs.si := cur^.xe + S_L;
                                   regs.di := cur^.ye + S_L;
                                   intr($33, regs);
                                   {setfillstyle(SolidFill, cur^.col);
                                   bar(cur^.xs + S_L, cur^.ys + S_L, cur^.xe + S_L, cur^.ye + S_L);
                                   setfillstyle(SolidFill, cur^.col + 8);
                                   bar(cur^.xs, cur^.ys, cur^.xe, cur^.ye);}
                                   DrawButton(cur^, false);
                                   regs.ax := $0021;
                                   intr($33, regs);
                                   regs.ax := $0004;
                                   regs.cx := xpos2;
                                   regs.dx := ypos2;
                                   intr($33, regs);
                                   regs.ax := $0001;
                                   intr($33, regs);
                                   cur^.down := false
                              end
                      end;
                      cur := cur^.next
                 end
     until picked
end;

function ButtonObject.CheckLastClick;

begin
end;

procedure ButtonObject.SetShadowLength;

begin
     S_L := s
end;

procedure ButtonObject.SetRadiusLength;

begin
     R_L := r
end;

procedure ButtonObject.Destruct;

var
   del, cur : _PBut_ListPtr;
   regs : registers;

begin
     cur := ButtonList^.prev;
     while cur <> ButtonList do
           begin
                del := cur;
                cur := cur^.prev;
                cur^.next := cur^.next^.next;
                cur^.next^.prev := cur;
                dispose(del)
           end;
     dispose(ButtonList);
     regs.ax := $000E;
     intr($33, regs)
end;

end.