unit PButV100;

interface

const
     LEFT_BUTTON = 0;
     MIDDLE_BUTTON = 2;
     RIGHT_BUTTON = 1;

type
    _PBut_ListPtr = ^_PBut_ListType;
    _PBut_ListType = record
                     key : string;
                     col : word;
                     xs, ys, xe, ye : integer;
                     prev, next : _PBut_ListPtr
                     end;

    ButtonObject = object

                   public

                   procedure InitPBut;
                   procedure AddButton(xs, ys, xe, ye : integer; col : word; key : string);
                   function RemoveButton(key : string) : boolean;
                   procedure ShowAllButtons;
                   function TrapClick(ButNum : integer) : string;
                   function CheckLastClick : string;
                   procedure SetShadowLength(s : integer);
                   procedure Destruct;

                   private

                   ButtonList : _PBut_ListPtr;
                   S_L : integer;

                   end;

implementation

uses
    graph, DOS;

procedure ButtonObject.InitPBut;

begin
     new(ButtonList);
     with ButtonList^ do
          begin
               xs := 0;
               ys := 0;
               xe := 0;
               ye := 0;
               next := ButtonList;
               prev := ButtonList;
               col := 0;
               key := ' '
          end;
     S_L := 2
end;

procedure ButtonObject.AddButton;

var
   cur1, cur2 : _PBut_ListPtr;

begin
     cur1 := ButtonList;
     while cur1^.next <> ButtonList do
           cur1 := cur1^.next;
     new(cur2);
     cur2^.prev := cur1;
     cur1^.next := cur2;
     cur2^.xs := xs;
     cur2^.ys := ys;
     cur2^.xe := xe;
     cur2^.ye := ye;
     cur2^.key := key;
     cur2^.col := col;
     cur2^.next := ButtonList
end;

function ButtonObject.RemoveButton;

var
   cur, del : _PBut_ListPtr;

begin
     cur := ButtonList^.next;
     while (cur^.key <> key) and (cur <> ButtonList) do
           cur := cur^.next;
     if cur^.key = key then
        begin
             RemoveButton := true;
             del := cur;
             cur := cur^.prev;
             cur^.next := cur^.next^.next;
             cur^.next^.prev := cur;
             dispose(del)
        end
     else
         RemoveButton := false
end;

procedure ButtonObject.ShowAllButtons;

var
   cur : _PBut_ListPtr;

begin
     cur := ButtonList^.next;
     while cur <> ButtonList do
           begin
                setfillstyle(SolidFill, cur^.col);
                bar(cur^.xs + S_L, cur^.ys + S_L, cur^.xe + S_L, cur^.ye + S_L);
                setfillstyle(SolidFill, cur^.col + 8);
                bar(cur^.xs, cur^.ys, cur^.xe, cur^.ye);
                cur := cur^.next
           end
end;

function ButtonObject.TrapClick;

var
   xpos, ypos : integer;
   cur : _PBut_ListPtr;
   regs : registers;
   picked : boolean;
   down : boolean;

begin
     xpos := -1;
     ypos := -1;
     picked := false;
     down := false;
     repeat
           regs.ax := $0005;
           regs.bx := ButNum;
           intr($33, regs);
           xpos := regs.cx;
           ypos := regs.dx;
           cur := ButtonList^.next;
           while (cur <> ButtonList) and not(picked) do
                 begin
                      if (xpos >= cur^.xs) and (xpos <= cur^.xe) and
                         (ypos >= cur^.ys) and (ypos <= cur^.ye) then
                               begin
                                    regs.ax := $0006;
                                    regs.bx := ButNum;
                                    intr($33, regs);
                                    if (regs.cx >= cur^.xs) and
                                       (regs.cx <= cur^.xe) and
                                       (regs.dx >= cur^.ys) and
                                       (regs.dx <= cur^.ye) then
                                                begin
                                                     regs.ax := $0003;
                                                     intr($33, regs);
                                                     case ButNum of
                                                          LEFT_BUTTON : if regs.bx mod 2 = 0 then
                                                                           begin
                                                                                picked := true;
                                                                                TrapClick := cur^.key
                                                                           end;
                                                          RIGHT_BUTTON : if regs.bx div 2 mod 2 = 0 then
                                                                            begin
                                                                                 picked := true;
                                                                                 TrapClick := cur^.key
                                                                            end
                                                     end
                                                end
                               end;
                      cur := cur^.next
                 end
     until picked
end;

function ButtonObject.CheckLastClick;

begin
end;

procedure ButtonObject.SetShadowLength;

begin
     S_L := s
end;

procedure ButtonObject.Destruct;

var
   del, cur : _PBut_ListPtr;

begin
     cur := ButtonList^.prev;
     while cur <> ButtonList do
           begin
                del := cur;
                cur := cur^.prev;
                cur^.next := cur^.next^.next;
                cur^.next^.prev := cur;
                dispose(del)
           end;
     dispose(ButtonList)
end;

end.