program DoomPics;
    uses
        crt,
        graph,
        PSndV102,
        PXMSV100;

    var
        Handle: word;
        gd, gm : integer;
        isize : longint;
        p : pointer;
        X : XMSObject;

    procedure WriteInfo;
        begin
            writeln('- - - - - - - - - - - - - -');
            writeln('XMS driver version:   ', X.GetXMSVersionStr);
            writeln('XMS driver internal:  ', X.GetXMSRevisionStr);
            writeln('Free XMS memory:      ', X.GetFreeXMS, 'k');
            writeln('Largest XMS block:    ', X.GetLargestXMSBlock, 'k');
            writeln('Press any key to continue...');
            repeat until KeyPressed;  ReadKey;
        end;

    procedure Init;
        begin
            if X.XMSInst
                then
                    begin
                        X.InitXMS;
                        writeln('XMS driver is installed');
                    end
                else
                    begin
                        writeln('No XMS driver installed!');
                        Halt;
                    end;
            WriteInfo;
            if X.GetFreeXMS = 0
                then
                    begin
                        writeln('No XMS available!  Terminating!');
                        Halt;
                    end;
        end;

    begin
        Init;

        gd := detect;
        initgraph(gd, gm, 'd:\tp\bgi');

        clearviewport;
        setfillstyle(solidfill, red);
        fillellipse(100, 100, 30, 30);
        isize := imagesize(70, 70, 130, 130);

        getmem(p, isize);
        getimage(70, 70, 130, 130, p^);

        readln;

        if X.AllocateEMB(Handle, isize div 1000 + 1) = false then
           halt;

        if X.CopyToEMB(p, isize, Handle, 0) = false then
           halt;

        closegraph;

        WriteInfo;

        initgraph(gd, gm, 'd:\tp\bgi');

        freemem(p, isize);

        getmem(p, isize);

        if X.CopyFromEMB(Handle, 0, isize, p) = false then
           halt;

        putimage(300, 300, p^, CopyPut);

        freemem(p, isize);

        readln;

        closegraph;

        X.FreeEMB(Handle);

        WriteInfo;

        writeln(isize);
        readln

    end.