unit PXMSV100;

interface

const
     XMSErrNoError             = $00;
     XMSErrNotImplemented      = $80;
     XMSErrVDiskDetected       = $81;
     XMSErrA20Error            = $82;
     XMSErrNoFreeXMS           = $A0;
     XMSErrNoFreeHandles       = $A1;
     XMSErrInvalidHandle       = $A2;
     XMSErrInvalidSourceHandle = $A3;
     XMSErrInvalidSourceOffset = $A4;
     XMSErrInvalidDestHandle   = $A5;
     XMSErrInvalidDestOffset   = $A6;
     XMSErrInvalidLength       = $A7;
     XMSErrInvalidOverlap      = $A8;
     XMSErrParity              = $A9;
     XMSErrBlockNotLocked      = $AA;
     XMSErrHandleLocked        = $AB;
     XMSErrLockCountOverflow   = $AC;
     XMSErrLockFailed          = $AD;

type
    PMoveParams = ^TMoveParams;
    TMoveParams = record
                        Length       : LongInt;
                        SourceHandle : word;
                        SourceOffset : LongInt;
                        DestHandle   : word;
                        DestOffset   : LongInt
                  end;

    XMSObject = object
                      function XMSInst : boolean;
                      procedure InitXMS;
                      function GetXMSVersion : word;
                      function GetXMSVersionStr : string;
                      function GetXMSRevision : word;
                      function GetXMSRevisionStr : string;
                      function GetLargestXMSBlock : word;
                      function GetFreeXMS : word;
                      function AllocateEMB(var Handle : word; Size : word) : boolean;
                      function ReallocateEMB(var Handle : word; NewSize : word) : boolean;
                      function MoveEMB(Params : PMoveParams) : boolean;
                      function FreeEMB(Handle : word) : boolean;
                      function CopyToEMB(SourcePtr : pointer; Length : LongInt; DestHandle : word;
                                         DestOffset : LongInt) : boolean;
                      function CopyFromEMB(SourceHandle : word; SourceOffset : LongInt; Length : LongInt;
                                           DestPtr : pointer) : boolean;
                      function GetXMSError : byte;
                      procedure ClearXMSError;
                      function GetXMSErrorStr(ErrorNum : byte) : string;

                end;

implementation

uses
    DOS;

var
   XMSDriver : pointer;
   XMSError : byte;
   TempParams : TMoveParams;

function XMSObject.XMSInst : boolean;

begin
     asm
        MOV    AX, 4300h
        INT    2Fh
        CMP    AL, $80
        JNE    @NoXMSDriver
        MOV    @Result, TRUE
        JMP    @Done
     @NoXMSDriver:
        MOV    @Result, FALSE
     @Done:
     end
end;

procedure XMSObject.InitXMS;

begin
     asm
        MOV    AX, 4310h
        INT    2Fh
        MOV    WORD PTR [XMSDriver], BX
        MOV    WORD PTR [XMSDriver+2], ES
     end
end;

function VerStr(w : word) : string;

var
   Num1, Num2, Num3: word;
   Str1, Str2, Str3: string;

begin
     Num1 := w and $0F00 shr 8;  Str(Num1, Str1);
     Num2 := w and $00F0 shr 4;  Str(Num2, Str2);
     Num3 := w and $000F;        Str(Num3, Str3);
     VerStr := Str1 + '.' + Str2 + Str3
end;

function XMSObject.GetXMSVersion : word;

begin
     asm
        MOV    AH, 00h
        CALL   XMSDriver
        MOV    @Result, AX
     end
end;

function XMSObject.GetXMSVersionStr: string;

begin
     GetXMSVersionStr := VerStr(GetXMSVersion)
end;

function XMSObject.GetXMSRevision: word;

begin
     asm
        MOV    AH, 00h
        CALL   XMSDriver
        MOV    @Result, BX
     end
end;

function XMSObject.GetXMSRevisionStr: string;

begin
     GetXMSRevisionStr := VerStr(GetXMSRevision)
end;

function XMSObject.GetLargestXMSBlock: word;

begin
     asm
        MOV    AH, 08h
        CALL   XMSDriver
        MOV    @Result, AX
     end
end;

function XMSObject.GetFreeXMS: word;

begin
     asm
        MOV    AH, 08h
        CALL   XMSDriver
        MOV    @Result, DX
     end
end;

function XMSObject.AllocateEMB(var Handle: word; Size: word): boolean;

begin
     asm
        MOV    AH, 09h
        MOV    DX, Size
        CALL   XMSDriver
        LES    DI, Handle
        MOV    [ES:DI], DX
        MOV    XMSError, BL
        MOV    @Result, AL
     end
end;

function XMSObject.ReallocateEMB(var Handle: word; NewSize: word): boolean;

begin
     asm
        MOV    AH, 0Fh
        MOV    BX, NewSize
        LES    DI, Handle
        MOV    DX, [ES:DI]
        MOV    XMSError, BL
        MOV    @Result, AL
     end
end;

function XMSObject.FreeEMB(Handle: word): boolean;

begin
     asm
        MOV    AH, 0Ah
        MOV    DX, Handle
        CALL   XMSDriver
        MOV    XMSError, BL
        MOV    @Result, AL
     end
end;

function XMSObject.MoveEMB(Params: PMoveParams): boolean;

begin
     asm
        MOV    AH, 0Bh
        LDS    SI, Params
        CALL   XMSDriver
        MOV    XMSError, BL
        MOV    @Result, AL
     end
end;

function XMSObject.CopyToEMB(SourcePtr: pointer;  Length: LongInt;  DestHandle: word; DestOffset: LongInt): boolean;

begin
     TempParams.Length       := Length;
     TempParams.SourceHandle := 0;
     TempParams.SourceOffset := LongInt(SourcePtr);
     TempParams.DestHandle   := DestHandle;
     TempParams.DestOffset   := DestOffset;
     CopyToEMB := MoveEMB(@TempParams)
end;

function XMSObject.CopyFromEMB(SourceHandle: word; SourceOffset: LongInt;  Length: LongInt;  DestPtr: pointer): boolean;

begin
     TempParams.Length       := Length;
     TempParams.SourceHandle := SourceHandle;
     TempParams.SourceOffset := SourceOffset;
     TempParams.DestHandle   := 0;
     TempParams.DestOffset   := LongInt(DestPtr);
     CopyFromEMB := MoveEMB(@TempParams)
end;

function XMSObject.GetXMSError: byte;

begin
     GetXMSError := XMSError
end;

procedure XMSObject.ClearXMSError;

begin
     XMSError := 0
end;

function XMSObject.GetXMSErrorStr(ErrorNum: byte): string;

var
   x : string;

begin
     case ErrorNum of
          $00: x:='No error';
          $80: x:='Function not implemented';
          $81: x:='VDISK detected';
          $82: x:='A20 Error';
          $A0: x:='No free XMS';
          $A1: x:='No free handles';
          $A2: x:='Invalid handle';
          $A3: x:='Invalid source handle';
          $A4: x:='Invalid source offset';
          $A5: x:='Invalid destination handle';
          $A6: x:='Invalid destination offset';
          $A7: x:='Invalid move length';
          $A8: x:='Invalid move overlap';
          $A9: x:='Parity error';
          $AA: x:='Extended memory block not locked';
          $AB: x:='Extended memory block locked';
          $AC: x:='Lock count overflow';
          $AD: x:='Lock failed';
          else x:='Unknown error'
     end;
     GetXMSErrorStr := x
end;

end.