program inttest;

uses
    crt,
    drivers,
    psndv102,
    dos;

const
     kbdint = $15;
     _U = $48;
     _D = $50;
     _L = $4B;
     _R = $4D;
     _C = $1D;
     _E = $01;

     _UP =     $48;
     _DOWN =   $50;
     _LEFT =   $4B;
     _RIGHT =  $4D;
     _CTRL =   $1D;
     _ESC =    $01;
     _LSHIFT = $2A;
     _RSHIFT = $36;
     _ALT =    $38;
     _TAB =    $0F;

var
   CtrlDn : boolean;
   Left : boolean;
   Right : boolean;
   Up, Down : boolean;
   Esc : boolean;
   regs : registers;
   ctr : integer;
   OldKbdVec : pointer;
   F : text;
   CtrlFlag, UpFlag, DownFlag, LeftFlag, RightFlag, EscFlag,
   LShiftFlag, RShiftFlag, AltFlag, TabFlag : boolean;
   Shifted : byte absolute $40:$17;

const
     XMSRequired   = 1400; {XMS memory required to load the sounds (KBytes)}
     SharedEMB = false; {Do not share the extended memory block (XMS)}
     NumSounds = 12; {Number of sounds used in this program.}
     SoundPaths : array[1..3] of string = ('', 'E:\POSHEN\PASCAL\CURRENT\',
                                           '..\SNDFILES\'); {Possible paths of sound files}

type
    Sounds = array[1..NumSounds] of PSound; {Sound array}

var
   BaseIO : word; {Base IO address of sound}
   IRQ, DMA, DMA16 : byte; {IRQ, DMA, DMA16 of sound}
   Sound : Sounds; {The sounds to be played}
   OldExitProc : pointer; {Pointer to linked list of exit procedures}

procedure otxy(x, y : integer; ch : char; col : word);

begin
     textcolor(col);
     gotoxy(x, y);
     write(ch)
end;

{$F+}

procedure sti;
inline($FB);

procedure cli;
inline($FA);

procedure CallOldInt(Sub : pointer);

begin
     inline($9C/          { PUSHF }
            $FF/$5E/$06); { CALL DWORD PTR [BP+6] }
end;

procedure Keyboard(Flags, CS, IP, AX, BX, CX, DX, SI, DI, DS, ES, BP : word); interrupt;

var
   data : byte;

begin
     if hi(AX) <> $4F then
        CallOldInt(OldKbdVec)
     else
         begin
              case lo(ax) of
                   _UP           : UpFlag     := true;
                   _DOWN         : DownFlag   := true;
                   _LEFT         : LeftFlag   := true;
                   _RIGHT        : RightFlag  := true;
                   _CTRL         : CtrlFlag   := true;
                   _ESC          : EscFlag    := true;
                   _ALT          : AltFlag    := true;
                   _LSHIFT       : LShiftFlag := true;
                   _RSHIFT       : RShiftFlag := true;
                   _TAB          : TabFlag    := true;
                   _UP + 128     : UpFlag     := false;
                   _DOWN + 128   : DownFlag   := false;
                   _LEFT + 128   : LeftFlag   := false;
                   _RIGHT + 128  : RightFlag  := false;
                   _CTRL + 128   : CtrlFlag   := false;
                   _ESC + 128    : EscFlag    := false;
                   _ALT + 128    : AltFlag    := false;
                   _LSHIFT + 128 : LShiftFlag := false;
                   _RSHIFT + 128 : RShiftFlag := false;
                   _TAB + 128    : TabFlag    := false
                   else
              end;                           {
              writeln(f, lo(ax));                }
              CallOldInt(OldKbdVec);
              if keypressed then
                 readkey;
              inline($FB)
         end
end;

{$F-}

function GetPossPath(SArr : array of string; fname : string) : string;

{finds a possible path for the specified file}

var
   ctr : integer; {Loop counter}
   tfile : file; {Temp. file}

begin {GetPossPath}
     for ctr := 0 to high(SArr) do {Searches through array}
         begin {for}
              assign(tfile, SArr[ctr]+fname);
              {$I-} {IO checking off}
              reset(tfile, 1);
              {$I+} {IO checking on}
              if IOResult = 0 then {If no error}
                 begin {if}
                      close(tfile);
                      GetPossPath := SArr[ctr]+fname; {Return path}
                      exit {Leave proc.}
                 end {if}
         end; {for}
     GetPossPath := fname {Return unmodified file name}
end; {GetPossPath}

function HexW(W : word) : string; {Word}

{====================================================================
FUNCTION DESCRIPTION: Converts a number from base 10 to base 16.
INPUT: A positive base 10 integer from calling module.
OUTPUT: A string containing the hexadecimal equivalent of the passed
        number to calling module.
====================================================================}

const
     HexChars : array [0..$F] of Char = '0123456789ABCDEF'; {Array of valid
                                                             hexadecimal
                                                             characters.}

begin {HexW}
     HexW := HexChars[(W and $F000) shr 12] + { Converts the number from}
             HexChars[(W and $0F00) shr 8]  + { base 10 to base 16.}
             HexChars[(W and $00F0) shr 4]  +
             HexChars[(W and $000F)]
end; {HexW}

procedure ClearProc; far;

{Auto terminate procedure.  In far call mode.}

begin {ClearProc}
     textcolor(LightGray); {Set to original colors}
     textbackground(Black);
     writeln;
     writeln('Goodbye!');
     writeln;
     SetIntVec(KbdInt, OldKbdVec);
     swapvectors; {Restore vectors}
     ExitProc := OldExitProc {Chain to next exit procedure}
end; {ClearProc}

procedure OurExitProc; far;

{====================================================================
PROCEDURE DESCRIPTION: If the program terminates with a runtime error
          before the extended memory is deallocated, then the memory
          will still be allocated, and will be lost until the next
          reboot.  This exit procedure is ALWAYS called upon program
          termination and will de-allocate extended memory if
          necessary.
INPUT: Pointer to the new exit procedure from calling module.
OUTPUT: None.
====================================================================}

var
   ctr : integer; {Loop counter}

begin {OurExitProc}
     for ctr := 1 to NumSounds do
         if Sound[ctr] <> nil then {If the memory allocated for the sound to
                                    be played has not yet been de-allocated...}
            FreeSound(Sound[ctr]); {De-allocates memory for the sound}
     if SharedEMB then {If the sounds are being stored in a shared EMB...}
        ShutdownSharing; {The sharing is stopped.}
     ExitProc := @ClearProc;
end; {OurExitProc}

procedure InitSound(var BaseIO : word; IRQ, DMA, DMA16 : byte; var Sound : Sounds; SoundPaths : array of string);

{====================================================================
PROCEDURE DESCRIPTION: Initializes the sound unit.
INPUT: BaseIO, IRQ, DMA, DMA16, sound variables from calling module.
OUTPUT: Modified BaseIO, IRQ, DMA, and DMA16 vars. to calling module.
====================================================================}

begin {InitSound}
     writeln; {Outputs a blank line}
     writeln('-------------------------------------------');
     writeln('Sound Mixing Library v1.27 by Ethan Brodsky'); {Credits}
     if not(GetSettings(BaseIO, IRQ, DMA, DMA16)) then {If the sound was not
                                                        detected...}
        begin {if}
             writeln('Error initializing:  Invalid or non-existant BLASTER environment variable');
                     {error message}
             writeln('Press ENTER.');
             readln;
             exit {BLASTER environment variable invalid or non-existant}
        end {if}
     else
         begin {else}
              if not(InitSB(BaseIO, IRQ, DMA, DMA16)) then {If the BLASTER
                                                            environment var.
                                                            was set
                                                            incorrectly...}
                 begin {if}
                      writeln('Error initializing sound card');{Error message}
                      writeln('Incorrect base IO address, sound card not installed, or broken');
                      writeln('Press ENTER.');
                      readln;
                      exit {Sound card could not be initialized}
                 end; {if}
              if SixteenBit then {If the sound card supports 16-bit mode...}
                 writeln('BaseIO=', HexW(BaseIO), 'h    IRQ', IRQ, '    DMA8=', DMA, '    DMA16=', DMA16)
                    {Stats. of 16-bit sound card.}
              else {8-bit}
                  writeln('BaseIO=', HexW(BaseIO), 'h        IRQ', IRQ, '        DMA8=', DMA)
                     {Stats. of 8-bit sound card.}
         end; {else}
     write('DSP version ', DSPVersion:0:2, ':  '); {Outputs the DSP version}
     if SixteenBit then {If it was 16-bit...}
        write('16-bit, ') {Notification}
     else {8-bit...}
         write('8-bit, '); {Notification}
     if AutoInit then {If it was auto-initialized...}
        writeln('Auto-initialized') {Notification}
     else {It is single-cycle...}
         writeln('Single-cycle'); {Notification}
     if not(InitXMS) then {This loads the sounds into extended memory.  If
                           there isn't any...}
        begin {if}
             writeln('Error initializing extended memory'); {Error message}
             writeln('HIMEM.SYS must be installed');
             writeln('Press ENTER.');
             exit {XMS driver not installed}
        end {if}
     else
         begin {else}
              writeln('Extended memory succesfully initialized');
              write('Free XMS memory:  ', GetFreeXMS, 'k  '); {Notification}
              if GetFreeXMS < XMSRequired then {Not enough XMS...}
                 begin {if}
                      writeln('Insufficient free XMS'); {Error message}
                      writeln('You are might be running this program from the protected mode IDE.');
                      writeln('Run it from the command line.');
                      writeln('If that doesn''t work, then try using a different machine');
                      writeln('that has more free XMS.');
                      writeln('The sounds will not be loaded.');
                      writeln('Press ENTER.');
                      exit {Insufficient XMS memory}
                 end {if}
              else
                  begin {else}
                       if SharedEMB then{If the sounds are to share an EMB...}
                          InitSharing; {Initialize the sharing}

                       writeln('Loading sounds...');


                          OpenSoundResourceFile(GetPossPath(SoundPaths, 'MUSIC.DAT'), 3); {Opens the sound
                                                            file.}

                          LoadSound(Sound[1], 'Background'); {Loads music}

                          CloseSoundResourceFile; {Closes the file}


                       OldExitProc := ExitProc; {Adds the exit procedure to
                                                 the list of others.}
                       ExitProc := @OurExitProc {Assigns the pointer to the
                                                 address of the exit procedure}
                  end {else}
         end; {else}
     InitMixing; {Allocates internal buffers and starts digitized sound
                  output}
     writeln
end; {InitSound}

procedure ShutdownSound(var Sound : Sounds);

{====================================================================
PROCEDURE DESCRIPTION: De-allocates memory for sound, shuts down EMB
                       sharing and frees all allocated extended
                       memory, if EMB sharing is on.
INPUT: The sound pointer from calling module.
OUTPUT: None.
====================================================================}

var
   ctr : integer;

begin {ShutDownSound}
     ShutdownMixing; {Deallocates internal buffers and stops digitized sound
                      output}
     ShutdownSB; {Removes interrupt handler and resets DSP}

     for ctr := 1 to NumSounds do {De-allocates all memory for sounds}
         if Sound[ctr] <> nil then {If the memory for the sound hasn't been
                                    de-allocated yet...}
            FreeSound(Sound[ctr]); {De-allocates memory for sound.}
     if SharedEMB then {If the sounds are in a shared EMB...}
        ShutdownSharing {Shuts down the EMB sharing.}
end; {ShutDownSound}


begin
     assign(f, 'output.dat');
     rewrite(f);
     InitPSound; {Inits sound unit}
     InitSound(BaseIO, IRQ, DMA, DMA16, Sound, SoundPaths); {Inits sounds}
     StartSound(Sound[1], 1, true); {Starts background music}
     delay(100);
     nosound;
     CtrlFlag := false;
     LeftFlag := false;
     RightFlag := false;
     UpFlag := false;
     DownFlag := false;
     EscFlag := false;
     ctr := 0;
     GetIntVec(KbdInt, OldKbdVec);

     SetIntVec(KbdInt, @Keyboard);

     clrscr;

     while not(EscFlag) do
           begin
                if CtrlFlag then
                   otxy(1, 1, 'C', lightred)
                else
                    otxy(1, 1, ' ', black);
                if UpFlag then
                   otxy(2, 2, 'U', blue)
                else
                    otxy(2, 2, ' ', black);
                if DownFlag then
                   otxy(2, 3, 'D', blue)
                else
                    otxy(2, 3, ' ', black);
                if LeftFlag then
                   otxy(1, 3, 'L', blue)
                else
                    otxy(1, 3, ' ', black);
                if RightFlag then
                   otxy(3, 3, 'R', blue)
                else
                    otxy(3, 3, ' ', black);
                if Shifted and kbLeftShift <> 0 then
                   otxy(7, 1, 'L', lightcyan)
                else
                    otxy(7, 1, ' ', black);
                if Shifted and kbRightShift <> 0 then
                   otxy(10, 1, 'R', lightcyan)
                else
                    otxy(10, 1, ' ', black);
                if AltFlag then
                   otxy(13, 5, 'A', yellow)
                else
                    otxy(13, 5, ' ', black);
                if TabFlag then
                   otxy(10, 10, 'T', white)
                else
                    otxy(10, 10, ' ', black)
           end;

     close(f);

     stopsound(1);
     shutdownsound(sound);

     SetIntVec(KbdInt, OldKbdVec)
end.