procedure PlotQuadFunc(a, b, c : real; xstart, xend : integer; xoff, yoff : integer; color : word);

{Pre:  None.
                                          2
 Post: Draws quadratic function: f(x) = ax  + bx + c.
       Starts at xstart and ends at xend.
       X coord. offset = xoff,
       Y coord. offest = yoff.
       color = color.}

var
   ctr : integer; {counter}

begin {PlotQuadFunc}
     setcolor(Color);
     for ctr := xstart to xend - 1 do {Loop through all the points on the arc}
         line(xoff + ctr, round(yoff - (a * sqr(ctr) + b * ctr + c)),
              xoff + ctr + 1, round(yoff - (a * sqr(ctr + 1) + b * (ctr + 1) + c)))
               {Connect succesive points on the quad. func}
end; {PlotQuadFunc}

procedure DrawMainRoom;

{Pre:  None.
 Post: Main room drawn on screen.}

begin {DrawMainRoom}
     setfillstyle(solidfill, blue); {draw Background}
     bar(0, 0, 640, 480);
     setcolor(Black); {Lines to inner box}
     line(0, 0, 200, 80);
     line(640, 0, 440, 80);
     line(0, 480, 200, 260);
     line(640, 480, 440, 260);
     rectangle(320, 120, 400, 180); {Exit doors}
     PlotQuadFunc(-13/3600, 1.1, 0, 0, 120, 200, 260, Black); {Quadratic curves}
     PlotQuadFunc(1/1800, -0.4, 0, 0, 120, 200, 80, Black); {Carpet border to door}
     PlotQuadFunc(-3/200, 8/5, 0, 0, 40, 400, 120, Black);
     PlotQuadFunc(9/400, -2.9, 0, 0, 40, 400, 180, Black);
     PlotQuadFunc(-49/10890, 11/9, 0, 0, 110, 220, 260, Black);
     PlotQuadFunc(89/1125, -233/45, 0, 0, 25, 395, 180, Black);
     line(40, 480, 220, 260); {Carpet lining}
     line(600, 480, 420, 260);
     setfillstyle(SolidFill, LightGray); {Exit doors}
     floodfill(360, 140, Black);
     line(360, 120, 360, 180);
     setcolor(Yellow);
     line(355, 140, 355, 160);   {Handles}
     line(365, 140, 365, 160);
     setfillstyle(SolidFill, Black); {Exit sign}
     bar(347, 111, 375, 129);
     bar(355, 105, 365, 111);
     setcolor(LightRed);
     rectangle(349, 113, 373, 127); {Exit text}
     line(351, 116, 351, 124);
     line(351, 116, 355, 116);
     line(351, 124, 355, 124);
     line(351, 120, 353, 120);
     line(357, 116, 361, 124);
     line(361, 116, 357, 124);
     line(364, 116, 364, 124);
     line(367, 116, 371, 116);
     line(369, 116, 369, 124);
     setfillstyle(SolidFill, LightBlue); {Ceiling}
     floodfill(320, 2, Black);
     floodfill(320, 100, Black);
     setfillstyle(SolidFill, Brown); {Carpet}
     floodfill(320, 478, Black);
     floodfill(320, 200, Black);
     setcolor(Brown);
     line(62, 414, 100, 414);
     line(152, 316, 200, 316);
     line(62, 414, 152, 316);
     line(598, 436, 200, 436);
     line(508, 337, 200, 337);
     line(598, 436, 508, 337);
     floodfill(70, 410, Brown);
     floodfill(595, 434, Brown);
     setcolor(Black);               {Side doors}
     line(40, 160, 40, 436);
     line(100, 170, 100, 370);
     line(160, 180, 160, 304);
     line(40, 160, 160, 180);
     line(620, 140, 620, 458);
     line(560, 150, 560, 392);
     line(500, 160, 500, 326);
     line(620, 140, 500, 160);
     setfillstyle(SolidFill, LightGray);
     floodfill(50, 170, Black);
     floodfill(110, 180, Black);
     floodfill(600, 170, Black);
     floodfill(540, 180, Black);
     setcolor(Yellow);                   {Handles}
     line(90, 230, 90, 320);
     line(110, 231, 110, 300);
     line(570, 220, 570, 330);
     line(550, 217, 550, 310);
     setcolor(DarkGray);                   {Flourescent lights}
     setfillstyle(SolidFill, White);
     line(300, 0, 325, 40);
     line(320, 0, 335, 40);
     line(325, 40, 335, 40);
     floodfill(323, 20, DarkGray);
     line(333, 60, 340, 60);
     line(333, 60, 352, 90);
     line(340, 60, 355, 90);
     line(352, 90, 355, 90);
     floodfill(335, 62, DarkGray);
     setcolor(Black);
     setfillstyle(SolidFill, DarkGray);   {Computer}
     rectangle(250, 370, 390, 380); {Base of computer}
     bar(251, 371, 389, 379);
     line(250, 370, 270, 350);
     line(390, 370, 370, 350);
     line(270, 350, 370, 350);
     floodfill(300, 360, Black);
     rectangle(280, 240, 360, 360); {Front panel}
     bar(281, 241, 359, 359);
     line(280, 240, 290, 230);
     line(360, 240, 350, 230);
     line(290, 230, 350, 230);
     floodfill(300, 235, Black);
     line(300, 250, 340, 250);    {Screen}
     line(300, 310, 340, 310);
     line(290, 260, 290, 300);
     line(350, 260, 350, 300);
     arc(300, 260, 90, 180, 10);
     arc(340, 260, 0, 90, 10);
     arc(300, 300, 180, 270, 10);
     arc(340, 300, 270, 360, 10);
     setfillstyle(SolidFill, Black);
     floodfill(320, 280, Black);
     setcolor(LightRed);
     line(305, 260, 305, 264);      {HELLO!}
     line(308, 260, 308, 264);
     line(306, 262, 307, 262);
     line(310, 260, 310, 264);
     line(311, 260, 313, 260);
     line(311, 262, 312, 262);
     line(311, 264, 313, 264);
     line(315, 260, 315, 264);
     line(316, 264, 319, 264);
     line(321, 260, 321, 264);
     line(322, 264, 325, 264);
     line(327, 261, 327, 263);
     line(330, 261, 330, 263);
     line(328, 260, 329, 260);
     line(328, 264, 329, 264);
     line(332, 260, 332, 262);
     putpixel(332, 264, LightRed);
     line(310, 275, 310, 285);                {   |   |   }
     line(330, 275, 330, 285);                { \       / }
     ellipse(320, 290, 180, 360, 20, 10);     {  -------  }
     setcolor(Black);
     setfillstyle(SolidFill, LightMagenta); {Lights}
     rectangle(290, 320, 300, 330);
     bar(291, 321, 299, 329);
     setfillstyle(SolidFill, LightRed);
     fillellipse(315, 325, 5, 5);
     setfillstyle(SolidFill, LightBlue);
     rectangle(290, 340, 300, 350);
     bar(291, 341, 299, 349);
     setfillstyle(SolidFill, LightCyan);
     rectangle(310, 340, 320, 350);
     bar(311, 341, 319, 349);
     rectangle(340, 325, 350, 345); {Power}
     line(340, 335, 350, 335);
     setfillstyle(SolidFill, LightGreen);
     bar(341, 326, 349, 334);
     setfillstyle(SolidFill, Red);
     bar(341, 336, 349, 344);
     setcolor(LightGreen);
     line(335, 328, 335, 332);
     setcolor(Red);
     circle(335, 341, 2)
end; {DrawMainRoom}

function OnChoice(row, col : integer; var Choice : byte) : boolean;

{Pre:  None.
 Post: Returns whether the mouse is on a hot spot in the main room}

begin {OnChoice}
     if (col > 250) and (row >= 350) and (col < 390) and (row < 380) then {If on save}
        begin {if}
             OnChoice := true;
             Choice := 2
        end {if}
     else if (col > 280) and (col < 360) and (row > 230) and (row < 350) then {If on save}
          begin {else-if}
               OnChoice := true;
               Choice := 2
          end {else-if}
     else if (row > 420) and (col > 100) and (col < 540) then {If on exit spot}
          begin {else-if}
               OnChoice := true;
               Choice := 5
          end {else-if}
     else if (col > 40) and (col < 160) and (row > col/6 - 20/3 + 160) and {If on upgrade room}
             (row < -1.1 * col + 480) then
                  begin {else-if}
                       OnChoice := true;
                       Choice := 1
                  end {else-if}
     else if (col > 500) and (col < 620) and (row > -col/6 + 250/3 + 160) and
             (row < 1.1 * col - 704 + 480) then {If on finance room}
                  begin {else-if}
                       OnChoice := true;
                       Choice := 4
                  end {else-if}
     else if (col > 320) and (col < 480) and (row > 120) and (row < 180) then {If on hangar door}
          begin {else-if}
               OnChoice := true;
               Choice := 3
          end {else-if}
     else
         OnChoice := false {Not on anything}
end; {OnChoice}

procedure WriteText(Choice : byte);

{Pre:  1 <= Choice <= 6.
 Post: Writes text on bottom of screen describing
       the place indicated by the mouse cursor}

begin {WriteText}
     settextstyle(TriplexFont, HorizDir, 4); {Init text face}
     settextjustify(CenterText, CenterText);
     setcolor(LightGreen);
     case Choice of {Branch based on what the passed argument is}
          1 : OutTextXY(320, 460, 'UPGRADES'); {Show the appropriate message}
          2 : OutTextXY(320, 460, 'SAVE GAME');
          3 : OutTextXY(320, 460, 'FLY MISSION');
          4 : OutTextXY(320, 460, 'FINANCE');
          5 : OutTextXY(320, 460, 'MAIN MENU')
     end {case}
end; {WriteText}

procedure DoGuns(var Pilot : Person);

{Pre:  None.
 Post: If desired, guns are bought}

var
   But : OldButtonObject; {Buttons}
   Mse : MouseObject; {Mouse}
   Chosen : boolean; {flag}
   GunNum : integer; {counter}
   Choice : string; {choice string}

begin {DoGuns}
     cleardevice;
     setcolor(LightCyan);
     settextstyle(TriplexFont, HorizDir, 3);
     settextjustify(CenterText, CenterText);
     OutTextXY(320, 30, 'Please choose the type of gun');
     OutTextXY(320, 60, 'that you would like to purchase:');
     OutTextXY(320, 90, 'Your cash = $' + LongToString(Pilot.Money)); {Show message}
     But.init;                {Init buttons}
     But.SetShadowLength(1);
     But.SetRadiusLength(1);
     But.SetTextColor(MenuTextColor);
     But.SetTextFont(SmallFont);
     But.SetTextSize(6);
     But.AddButton(250, 300, 300, 320, MenuButtonColor, '<<', '<-'); {Add buttons}
     But.AddButton(340, 300, 390, 320, MenuButtonColor, '>>', '->');
     But.AddButton(250, 360, 300, 380, MenuButtonColor, 'OK', 'OK');
     But.AddButton(340, 360, 390, 380, MenuButtonColor, 'EXIT', 'EXIT');
     Chosen := false;
     GunNum := 1;
     repeat {Wait until OK or EXIT picked}
           setcolor(LightCyan);
           settextstyle(TriplexFont, HorizDir, 3);
           settextjustify(CenterText, CenterText);
           OutTextXY(320, 120, 'Your gun:');
           DrawGun(320, 150, Pilot.Gun); {Show description of your gun}
           setcolor(LightCyan);
           OutTextXY(320, 200, 'Gun:');
           DrawGun(320, 230, GunNum); {Show description of current gun}
           setcolor(LightBlue);
           OutTextXY(320, 260, 'Price: $' + LongToString(Prices[GUNS, GunNum]));
            {Show your money}
           But.ShowAllButtons; {Show all buttons}
           Mse.showmouse; {show mouse}
           Choice := But.Trapclick(Left_Button); {trap click}
           Mse.hidemouse; {hide mouse}
           case Choice[1] of {branch based on what the button was}
                '<' : begin {<-}
                           EraseGun(320, 230, GunNum); {Erase gun desc.}
                           setcolor(Black);
                           OutTextXY(320, 260, 'Price: $' + LongToString(Prices[GUNS, GunNum]));
                           GunNum := GunNum - 1;
                           if GunNum < 1 then {If counter overflowed}
                              GunNum := NumWeapons {Loop back around}
                      end; {<-}
                '-' : begin {->}
                           EraseGun(320, 230, GunNum); {Erase gun desc.}
                           setcolor(Black);
                           OutTextXY(320, 260, 'Price: $' + LongToString(Prices[GUNS, GunNum]));
                           GunNum := GunNum + 1;
                           if GunNum > NumWeapons then {If counter overflowed}
                              GunNum := 1 {Loop back around}
                      end; {->}
                'O' : begin {OK}
                           if Pilot.Money >= Prices[GUNS, GunNum] - Prices[GUNS, Pilot.Gun] then {If you have enough money}
                              begin {if}
                                   Chosen := true;
                                   setcolor(LightCyan);
                                   settextstyle(TriplexFont, HorizDir, 3);
                                   settextjustify(CenterText, CenterText);
                                   setcolor(black);
                                   OutTextXY(320, 90, 'Your cash = $' + LongToString(Pilot.Money));
                                    {Erase monetary status}
                                   Pilot.Money := Pilot.Money - Prices[GUNS, GunNum] + Prices[GUNS, Pilot.Gun];
                                    {Update money}
                                   setcolor(LightCyan);
                                   OutTextXY(320, 90, 'Your cash = $' + LongToString(Pilot.Money));
                                    {Update monetary status}
                                   if Pilot.Gun <> GunNum then {If this is not your gun}
                                      begin {if}
                                           settextstyle(SmallFont, HorizDir, 5); {Show thank you message}
                                           settextjustify(CenterText, CenterText);
                                           setcolor(LightCyan);
                                           OutTextXY(320, 440, 'THANK YOU!');
                                           delay(1000);
                                           setcolor(Black);
                                           OutTextXY(320, 440, 'THANK YOU!');
                                           Pilot.Gun := GunNum
                                      end {if}
                              end {if}
                           else {Not enough money}
                               begin {else}
                                    settextstyle(SmallFont, HorizDir, 4);
                                    settextjustify(CenterText, CenterText);
                                    setcolor(LightRed);
                                    OutTextXY(320, 290, 'INSUFFICIENT CREDIT!'); {Show error message}
                                    delay(1000);
                                    setcolor(Black);
                                    OutTextXY(320, 290, 'INSUFFICIENT CREDIT!')
                               end {else}
                      end; {OK}
                'E' : Chosen := true {EXIT}
           end {case}
     until Chosen;
     But.destruct; {deallocate memory for buttons}
     if Pilot.Gun = 2 then {If you have the machine gun}
        Pilot.Automatic := true {flag true}
     else
         Pilot.Automatic := false {flag false}
end; {DoGuns}

procedure DoThrusters(var Pilot : Person);

{Pre:  None.
 Post: If desired, thrusters are upgraded}

var
   But : OldButtonObject; {buttons}
   Mse : MouseObject; {mouse}
   Chosen : boolean; {flag}
   ThrustNum : integer; {counter}
   Choice : string; {flag}

begin {DoThrusters}
     cleardevice;
     setcolor(LightCyan);
     settextstyle(TriplexFont, HorizDir, 3);
     settextjustify(CenterText, CenterText);
     OutTextXY(320, 30, 'Please choose the type of thruster');
     OutTextXY(320, 60, 'that you would like to purchase:');
     OutTextXY(320, 90, 'Your cash = $' + LongToString(Pilot.Money));
      {Show message}
     But.init;                  {Initialize buttons}
     But.SetShadowLength(1);
     But.SetRadiusLength(1);
     But.SetTextColor(MenuTextColor);
     But.SetTextFont(SmallFont);
     But.SetTextSize(6);
     But.AddButton(250, 300, 300, 320, MenuButtonColor, '<<', '<-'); {Add buttons}
     But.AddButton(340, 300, 390, 320, MenuButtonColor, '>>', '->');
     But.AddButton(250, 360, 300, 380, MenuButtonColor, 'OK', 'OK');
     But.AddButton(340, 360, 390, 380, MenuButtonColor, 'EXIT', 'EXIT');
     Chosen := false;
     ThrustNum := 1;
     repeat {Wait until OK or EXIT chosen}
           setcolor(LightCyan);
           settextstyle(TriplexFont, HorizDir, 3);
           settextjustify(CenterText, CenterText);
           OutTextXY(320, 120, 'Your thruster:');
           DrawThruster(320, 150, Pilot.Thruster); {Describe your thruster}
           setcolor(LightCyan);
           OutTextXY(320, 200, 'Thruster:');
           DrawThruster(320, 230, ThrustNum); {Describe current thruster}
           setcolor(LightBlue);
           OutTextXY(320, 260, 'Price: $' + LongToString(Prices[THRUSTERS, ThrustNum]));
            {Show price}
           But.ShowAllButtons; {show all buttons}
           Mse.showmouse; {show mouse cursor}
           Choice := But.Trapclick(Left_Button); {trap click}
           Mse.hidemouse; {hide mouse cursor}
           case Choice[1] of {branch based on what button was pressed}
                '<' : begin {<-}
                           EraseThruster(320, 230, ThrustNum); {Erase thruster}
                           setcolor(Black);
                           OutTextXY(320, 260, 'Price: $' + LongToString(Prices[THRUSTERS, ThrustNum]));
                            {erase price}
                           ThrustNum := ThrustNum - 1;
                           if ThrustNum < 1 then {If counter overflows}
                              ThrustNum := NumWeapons {Loop back}
                      end;  {<-}
                '-' : begin {->}
                           EraseThruster(320, 230, ThrustNum); {erase thruster}
                           setcolor(Black);
                           OutTextXY(320, 260, 'Price: $' + LongToString(Prices[THRUSTERS, ThrustNum]));
                            {erase price}
                           ThrustNum := ThrustNum + 1;
                           if ThrustNum > NumWeapons then {If counter overflows}
                              ThrustNum := 1 {loop back}
                      end; {->}
                'O' : begin {OK}
                           if Pilot.Money >= Prices[THRUSTERS, ThrustNum] - Prices[THRUSTERS, Pilot.Thruster] then
                            {If you have enough money}
                              begin {if}
                                   Chosen := true;
                                   setcolor(LightCyan);
                                   settextstyle(TriplexFont, HorizDir, 3);
                                   settextjustify(CenterText, CenterText);
                                   setcolor(black);
                                   OutTextXY(320, 90, 'Your cash = $' + LongToString(Pilot.Money));
                                    {Erase monetary status}
                                   Pilot.Money := Pilot.Money - Prices[THRUSTERS, ThrustNum] +
                                                  Prices[THRUSTERS, Pilot.Thruster];
                                    {update monetary status}
                                   setcolor(LightCyan);
                                   OutTextXY(320, 90, 'Your cash = $' + LongToString(Pilot.Money));
                                    {draw monetary status}
                                   if Pilot.Thruster <> ThrustNum then {If this is not your thruster}
                                      begin {if}
                                           settextstyle(SmallFont, HorizDir, 5); {Show thank you message}
                                           settextjustify(CenterText, CenterText);
                                           setcolor(LightCyan);
                                           OutTextXY(320, 440, 'THANK YOU!');
                                           delay(1000);
                                           setcolor(Black);
                                           OutTextXY(320, 440, 'THANK YOU!');
                                           Pilot.Thruster := ThrustNum
                                      end {if}
                              end {if}
                           else {not enough money}
                               begin {else}
                                    settextstyle(SmallFont, HorizDir, 4);
                                    settextjustify(CenterText, CenterText);
                                    setcolor(LightRed);
                                    OutTextXY(320, 290, 'INSUFFICIENT CREDIT!'); {show error}
                                    delay(1000); {wait}
                                    setcolor(Black);
                                    OutTextXY(320, 290, 'INSUFFICIENT CREDIT!') {erase error}
                               end {else}
                      end; {OK}
                'E' : Chosen := true {EXIT chosen}
           end {case}
     until Chosen;
     Pilot.AccDelay := 11 - Pilot.Thruster {Update acceleration speeds}
end; {DoThrusters}

procedure DoShields(var Pilot : Person);

{Pre:  None.
 Post: Shields are upgraded if necessary}

var
   But : OldButtonObject; {Buttons}
   Mse : MouseObject; {mouse}
   Chosen : boolean; {flag}
   ShieldNum : integer; {counter}
   Choice : string; {button choice}

begin {DoShields}
     cleardevice;
     setcolor(LightCyan);
     settextstyle(TriplexFont, HorizDir, 3);
     settextjustify(CenterText, CenterText);
     OutTextXY(320, 30, 'Please choose the type of shield');
     OutTextXY(320, 60, 'that you would like to purchase:');
     OutTextXY(320, 90, 'Your cash = $' + LongToString(Pilot.Money));
      {Show message}
     But.init;                  {Init buttons}
     But.SetShadowLength(1);
     But.SetRadiusLength(1);
     But.SetTextColor(MenuTextColor);
     But.SetTextFont(SmallFont);
     But.SetTextSize(6);
     But.AddButton(250, 300, 300, 320, MenuButtonColor, '<<', '<-'); {Add buttons}
     But.AddButton(340, 300, 390, 320, MenuButtonColor, '>>', '->');
     But.AddButton(250, 360, 300, 380, MenuButtonColor, 'OK', 'OK');
     But.AddButton(340, 360, 390, 380, MenuButtonColor, 'EXIT', 'EXIT');
     Chosen := false;
     ShieldNum := 1;
     repeat {Wait until OK or EXIT are chosen}
           setcolor(LightCyan);
           settextstyle(TriplexFont, HorizDir, 3);
           settextjustify(CenterText, CenterText);
           OutTextXY(320, 120, 'Your shield:');
           DrawShieldDesc(320, 150, Pilot.ShieldType); {Describe shield}
           setcolor(LightCyan);
           OutTextXY(320, 200, 'Shield:');
           DrawShieldDesc(320, 230, ShieldNum); {Describe shield}
           setcolor(LightBlue);
           OutTextXY(320, 260, 'Price: $' + LongToString(Prices[SHIELDS, ShieldNum]));
            {Show price}
           But.ShowAllButtons; {show all buttons}
           Mse.showmouse; {show mouse}
           Choice := But.Trapclick(Left_Button); {trap click}
           Mse.hidemouse; {hide mouse}
           case Choice[1] of {branch based on what button is pressed}
                '<' : begin {<-}
                           EraseShieldDesc(320, 230, ShieldNum); {erase shield description}
                           setcolor(Black);
                           OutTextXY(320, 260, 'Price: $' + LongToString(Prices[SHIELDS, ShieldNum]));
                            {erase old price}
                           ShieldNum := ShieldNum - 1;
                           if ShieldNum < 1 then {If counter overflowed}
                              ShieldNum := NumWeapons {Loop back}
                      end; {<-}
                '-' : begin {->}
                           EraseShieldDesc(320, 230, ShieldNum); {erase shield description}
                           setcolor(Black);
                           OutTextXY(320, 260, 'Price: $' + LongToString(Prices[SHIELDS, ShieldNum]));
                            {erase old price}
                           ShieldNum := ShieldNum + 1;
                           if ShieldNum > NumWeapons then {If counter overflowed}
                              ShieldNum := 1 {Loop back around}
                      end; {->}
                'O' : begin {OK}
                           if Pilot.Money >= Prices[SHIELDS, ShieldNum] - Prices[SHIELDS, Pilot.ShieldType] then
                            {If you have enough money}
                              begin {if}
                                   Chosen := true;
                                   setcolor(LightCyan);
                                   settextstyle(TriplexFont, HorizDir, 3);
                                   settextjustify(CenterText, CenterText);
                                   setcolor(black);
                                   OutTextXY(320, 90, 'Your cash = $' + LongToString(Pilot.Money));
                                    {Erase monetary status}
                                   Pilot.Money := Pilot.Money - Prices[SHIELDS, ShieldNum] +
                                                  Prices[SHIELDS, Pilot.ShieldType];
                                    {update monetary status}
                                   setcolor(LightCyan);
                                   OutTextXY(320, 90, 'Your cash = $' + LongToString(Pilot.Money));
                                    {draw monetary status}
                                   if Pilot.ShieldType <> ShieldNum then {If this is not your shield}
                                      begin {if}
                                           settextstyle(SmallFont, HorizDir, 5); {Show thank you message}
                                           settextjustify(CenterText, CenterText);
                                           setcolor(LightCyan);
                                           OutTextXY(320, 440, 'THANK YOU!');
                                           delay(1000);
                                           setcolor(Black);
                                           OutTextXY(320, 440, 'THANK YOU!');
                                           Pilot.ShieldType := ShieldNum
                                      end {if}
                              end {if}
                           else {Not enough money}
                               begin {else}
                                    settextstyle(SmallFont, HorizDir, 4);
                                    settextjustify(CenterText, CenterText);
                                    setcolor(LightRed);
                                    OutTextXY(320, 290, 'INSUFFICIENT CREDIT!'); {show error message}
                                    delay(1000); {wait}
                                    setcolor(Black);
                                    OutTextXY(320, 290, 'INSUFFICIENT CREDIT!') {erase error message}
                               end {else}
                      end; {OK}
                'E' : Chosen := true {EXIT chosen}
           end {case}
     until Chosen;
     But.destruct; {deallocate all memory for buttons}
     Pilot.MaxShields := 10 * Pilot.ShieldType {Modify shield max. level}
end; {DoShields}

procedure DoGenerator(var Pilot : Person);

{Pre:  None.
 Post: Generators are purchased if desired}

var
   But : OldButtonObject; {buttons}
   Mse : MouseObject; {mouse}
   Chosen : boolean; {flag}
   GenNum : integer; {counter}
   Choice : string; {button choice}

begin {DoGenerator}
     cleardevice;
     setcolor(LightCyan);
     settextstyle(TriplexFont, HorizDir, 3);
     settextjustify(CenterText, CenterText);
     OutTextXY(320, 30, 'Please choose the type of generator');
     OutTextXY(320, 60, 'that you would like to purchase:');
     OutTextXY(320, 90, 'Your cash = $' + LongToString(Pilot.Money));
      {Output message}
     But.init;                  {Set up buttons}
     But.SetShadowLength(1);
     But.SetRadiusLength(1);
     But.SetTextColor(MenuTextColor);
     But.SetTextFont(SmallFont);
     But.SetTextSize(6);
     But.AddButton(250, 300, 300, 320, MenuButtonColor, '<<', '<-'); {Add buttons}
     But.AddButton(340, 300, 390, 320, MenuButtonColor, '>>', '->');
     But.AddButton(250, 360, 300, 380, MenuButtonColor, 'OK', 'OK');
     But.AddButton(340, 360, 390, 380, MenuButtonColor, 'EXIT', 'EXIT');
     Chosen := false;
     GenNum := 1;
     repeat {Wait until OK or EXIT are pressed}
           setcolor(LightCyan);
           settextstyle(TriplexFont, HorizDir, 3);
           settextjustify(CenterText, CenterText);
           OutTextXY(320, 120, 'Your generator:');
           DrawGenerator(320, 150, Pilot.GeneratorType); {Describe your generator}
           setcolor(LightCyan);
           OutTextXY(320, 200, 'Generator:');
           DrawGenerator(320, 230, GenNum); {Describe generator}
           setcolor(LightBlue);
           OutTextXY(320, 260, 'Price: $' + LongToString(Prices[GENERATORS, GenNum]));
            {Show price}
           But.ShowAllButtons; {show all buttons}
           Mse.showmouse; {show mouse cursor}
           Choice := But.Trapclick(Left_Button); {trap click}
           Mse.hidemouse; {Hide mouse cursor}
           case Choice[1] of {Branch based on what button is pressed}
                '<' : begin {<-}
                           EraseGenerator(320, 230, GenNum); {Erase gen. desc.}
                           setcolor(Black);
                           OutTextXY(320, 260, 'Price: $' + LongToString(Prices[GENERATORS, GenNum]));
                            {erase price}
                           GenNum := GenNum - 1;
                           if GenNum < 1 then {If counter overflowed}
                              GenNum := NumWeapons {Loop back}
                      end; {<-}
                '-' : begin {->}
                           EraseGenerator(320, 230, GenNum); {Erase gen. desc.}
                           setcolor(Black);
                           OutTextXY(320, 260, 'Price: $' + LongToString(Prices[GENERATORS, GenNum]));
                            {erase price}
                           GenNum := GenNum + 1;
                           if GenNum > NumWeapons then {If counter overflowed}
                              GenNum := 1 {Loop back}
                      end; {->}
                'O' : begin {OK}
                           if Pilot.Money >= Prices[GENERATORS, GenNum] - Prices[GENERATORS, Pilot.GeneratorType] then
                            {If you have enough money}
                              begin {if}
                                   Chosen := true;
                                   setcolor(LightCyan);
                                   settextstyle(TriplexFont, HorizDir, 3);
                                   settextjustify(CenterText, CenterText);
                                   setcolor(black);
                                   OutTextXY(320, 90, 'Your cash = $' + LongToString(Pilot.Money));
                                    {Erase monetary status}
                                   Pilot.Money := Pilot.Money - Prices[GENERATORS, GenNum] +
                                                  Prices[GENERATORS, Pilot.GeneratorType];
                                    {Update monetary status}
                                   setcolor(LightCyan);
                                   OutTextXY(320, 90, 'Your cash = $' + LongToString(Pilot.Money));
                                    {Draw monetary status}
                                   if Pilot.GeneratorType <> GenNum then {If this is not your generator}
                                      begin {if}
                                           settextstyle(SmallFont, HorizDir, 5); {Show thank you message}
                                           settextjustify(CenterText, CenterText);
                                           setcolor(LightCyan);
                                           OutTextXY(320, 440, 'THANK YOU!');
                                           delay(1000);
                                           setcolor(Black);
                                           OutTextXY(320, 440, 'THANK YOU!');
                                           Pilot.GeneratorType := GenNum {Update generator type}
                                      end {if}
                              end {if}
                           else {Too little money}
                               begin {else}
                                    settextstyle(SmallFont, HorizDir, 4);
                                    settextjustify(CenterText, CenterText);
                                    setcolor(LightRed);
                                    OutTextXY(320, 290, 'INSUFFICIENT CREDIT!'); {Show error}
                                    delay(1000); {wait}
                                    setcolor(Black);
                                    OutTextXY(320, 290, 'INSUFFICIENT CREDIT!') {Erase error}
                               end {else}
                      end; {OK}
                'E' : Chosen := true {EXIT chosen}
           end {case}
     until Chosen;
     But.destruct; {Deallocate all memory for buttons}
     Pilot.RechargeDelay := 11 - Pilot.GeneratorType; {Update recharge delay}
     if Pilot.RechargeDelay < 1 then
        Pilot.RechargeDelay := 1
end; {DoGenerators}

procedure DoSpecials(var Pilot : Person);

{Pre:  None.
 Post: Special weapons are purchased if desired}

var
   But : OldButtonObject; {buttons}
   Mse : MouseObject; {mouse}
   Chosen : boolean; {flag}
   SpeNum : integer; {counter}
   Choice : string; {button choice}
   ctr : integer; {counter}

begin {DoSpecials}
     cleardevice;
     setcolor(LightCyan);
     settextstyle(TriplexFont, HorizDir, 3);
     settextjustify(CenterText, CenterText);
     OutTextXY(320, 30, 'Please choose the specials');
     OutTextXY(320, 60, 'that you would like to purchase:');
     OutTextXY(320, 90, 'Your cash = $' + LongToString(Pilot.Money));
      {Show message}
     But.init;                         {Set up buttons}
     But.SetShadowLength(1);
     But.SetRadiusLength(1);
     But.SetTextColor(MenuTextColor);
     But.SetTextFont(SmallFont);
     But.SetTextSize(6);
     But.AddButton(250, 300, 300, 320, MenuButtonColor, '<<', '<-'); {Add buttons}
     But.AddButton(340, 300, 390, 320, MenuButtonColor, '>>', '->');
     But.AddButton(250, 360, 300, 380, MenuButtonColor, 'BUY', 'BUY');
     But.AddButton(340, 360, 390, 380, MenuButtonColor, 'EXIT', 'EXIT');
     But.SetTextColor(LightRed);
     But.AddButton(270, 330, 370, 350, LightRed, 'SELL', 'SELL');
     Chosen := false;
     SpeNum := 1;
     repeat {Wait until OK or EXIT chosen}
           setcolor(LightCyan);
           settextstyle(TriplexFont, HorizDir, 3);
           settextjustify(CenterText, CenterText);
           OutTextXY(320, 90, 'Your cash = $' + LongToString(Pilot.Money));
           setcolor(LightCyan);
           OutTextXY(320, 200, 'Special:');
           DrawSpec(320, 230, SpeNum); {Draw special}
           setcolor(LightBlue);
           OutTextXY(320, 260, 'Price: $' + LongToString(SpePrices[SpeNum]));
           But.ShowAllButtons; {show all buttons}
           Mse.showmouse; {show mouse cursor}
           Choice := But.Trapclick(Left_Button); {trap click}
           Mse.hidemouse; {hide mouse cursor}
           case Choice[1] of {branch based on the button pressed}
                '<' : begin {<-}
                           EraseSpec(320, 230, SpeNum); {erase description}
                           setcolor(Black);
                           OutTextXY(320, 260, 'Price: $' + LongToString(SpePrices[SpeNum]));
                            {erase price}
                           SpeNum := SpeNum - 1;
                           if SpeNum < 1 then {If counter overflowed}
                              SpeNum := NumSpecials {Loop back}
                      end; {<-}
                '-' : begin {->}
                           EraseSpec(320, 230, SpeNum); {erase description}
                           setcolor(Black);
                           OutTextXY(320, 260, 'Price: $' + LongToString(SpePrices[SpeNum]));
                            {erase price}
                           SpeNum := SpeNum + 1;
                           if SpeNum > NumSpecials then {If counter overflowed}
                              SpeNum := 1 {Loop back}
                      end; {->}
                'B' : begin {BUY}
                           if Pilot.Money >= SpePrices[SpeNum] then {If you have enough money}
                              begin {if}
                                   Pilot.Specials[SpeNum] := Pilot.Specials[SpeNum] + 1;
                                    {Add it to your inventory}
                                   setcolor(Black);
                                   settextstyle(TriplexFont, HorizDir, 3);
                                   settextjustify(CenterText, CenterText);
                                   OutTextXY(320, 90, 'Your cash = $' + LongToString(Pilot.Money));
                                    {erase monetary status}
                                   Pilot.Money := Pilot.Money - SpePrices[SpeNum];
                                    {update monetary stautus}
                                   setcolor(LightCyan);
                                   settextstyle(TriplexFont, HorizDir, 3);
                                   settextjustify(CenterText, CenterText);
                                   OutTextXY(320, 90, 'Your cash = $' + LongToString(Pilot.Money));
                                    {show monetary status}
                                   settextstyle(SmallFont, HorizDir, 5); {Show thank you message}
                                   settextjustify(CenterText, CenterText);
                                   setcolor(LightCyan);
                                   OutTextXY(320, 440, 'THANK YOU!'); {Show message}
                                   delay(100); {wait}
                                   setcolor(Black);
                                   OutTextXY(320, 440, 'THANK YOU!'); {erase message}
                                   if Pilot.SpePosition = 0 then {If no specials}
                                      Pilot.SpePosition := SpeNum {special at position just purchased}
                              end {if}
                           else {not enough money}
                               begin {else}
                                    settextstyle(SmallFont, HorizDir, 4);
                                    settextjustify(CenterText, CenterText);
                                    setcolor(LightRed);
                                    OutTextXY(320, 290, 'INSUFFICIENT CREDIT!'); {show error}
                                    delay(1000); {wait}
                                    setcolor(Black);
                                    OutTextXY(320, 290, 'INSUFFICIENT CREDIT!') {erase error}
                               end {else}
                      end; {BUY}
                'S' : begin {SELL}
                           if (SpeNum <> 0) and (Pilot.Specials[SpeNum] > 0) then {If there are still some specials}
                              begin {if}
                                   Pilot.Specials[SpeNum] := Pilot.Specials[SpeNum] - 1; {Remove special from inventory}
                                   setcolor(Black);
                                   settextstyle(TriplexFont, HorizDir, 3);
                                   settextjustify(CenterText, CenterText);
                                   OutTextXY(320, 90, 'Your cash = $' + LongToString(Pilot.Money));
                                    {erase monetary status}
                                   Pilot.Money := Pilot.Money + SpePrices[SpeNum];
                                    {Update monetary status}
                                   setcolor(LightCyan);
                                   settextstyle(TriplexFont, HorizDir, 3);
                                   settextjustify(CenterText, CenterText);
                                   OutTextXY(320, 90, 'Your cash = $' + LongToString(Pilot.Money));
                                    {show monetary status}
                                   settextstyle(SmallFont, HorizDir, 5); {Show thank you message}
                                   settextjustify(CenterText, CenterText);
                                   setcolor(LightCyan);
                                   OutTextXY(320, 440, 'THANK YOU!'); {Show message}
                                   delay(100); {wait}
                                   setcolor(Black);
                                   OutTextXY(320, 440, 'THANK YOU!'); {erase message}
                                   if (Pilot.SpePosition = SpeNum) and (Pilot.Specials[SpeNum] = 0) then
                                    {If no specials left in this category}
                                      begin {if}
                                           Pilot.SpePosition := 0; {Set special position to zero, indicating absence of}
                                           for ctr := 1 to NumSpecials do {search for next special}
                                               if Pilot.Specials[ctr] > 0 then {If there is a special here}
                                                  Pilot.SpePosition := ctr {Modify special position}
                                      end {if}
                              end {if}
                           else {not in inventory}
                               begin {else}
                                    settextstyle(SmallFont, HorizDir, 4);
                                    settextjustify(CenterText, CenterText);
                                    setcolor(LightRed);
                                    OutTextXY(320, 290, 'NOT IN YOUR INVENTORY!'); {show error}
                                    delay(1000); {wait}
                                    setcolor(Black);
                                    OutTextXY(320, 290, 'NOT IN YOUR INVENTORY!') {erase error}
                               end {else}
                      end; {SELL}
                'E' : Chosen := true {EXIT chosen}
           end {case}
     until Chosen;
     but.destruct {deallocate all memory for buttons}
end; {DoSpecials}

procedure DoUpgrades(var Pilot : Person);

{Pre:  None.
 Post: All upgrades are offered}

var
   par : ParaType; {Flashing text}
   But : OldButtonObject; {buttons}
   Mse : MouseObject; {mouse}
   Choice : string; {button choice}
   Leave : boolean; {flag}

begin {DoUpgrades}
     cleardevice;
     par[1] := 'WELCOME TO THE AUTOMATED PURCHASE SYSTEM!                   '; {Prepare text}
     par[2] := 'ALL PURCHASES WILL BE AUTOMATICALLY CREDITED                ';
     par[3] := 'TO YOUR ACCOUNT, AND ALL UPGRADES WILL BE                   ';
     par[4] := 'MOUNTED ON YOUR SHIP.                                       ';
     Fnt.psflashpara(45, 100, FlashSize, Green, 12, 20, 4, 44, FlashSpeed, 3, par); {Flash text}
     But.init;                           {set up buttons}
     But.SetShadowLength(1);
     But.SetRadiusLength(1);
     But.SetTextColor(MenuTextColor);
     But.SetTextFont(SmallFont);
     But.SetTextSize(6);
     But.AddButton(30, 320, 122, 412, MenuButtonColor, 'Guns', 'g');      {Add buttons}
     But.AddButton(152, 320, 244, 412, MenuButtonColor, 'Thruster', 't');
     But.AddButton(274, 320, 366, 412, MenuButtonColor, 'Shield', 's');
     But.AddButton(396, 320, 488, 412, MenuButtonColor, 'Generator', 'G');
     But.AddButton(518, 320, 610, 412, MenuButtonColor, 'Specials', 'S');
     But.AddButton(30, 430, 610, 470, MenuButtonColor, 'Exit', 'x');
     Leave := false;
     repeat {Wait until EXIT is chosen}
           settextjustify(CenterText, CenterText);
           settextstyle(TriplexFont, HorizDir, 3);
           setcolor(LightCyan);
           OutTextXY(320, 225, 'Upgrade:');
           But.ShowAllButtons; {Show all buttons}
           Mse.ShowMouse; {show mouse}
           Choice := But.TrapClick(Left_Button); {trap click}
           Mse.HideMouse; {hide mouse}
           case Choice[1] of {branch based on the button selected}
                'g' : DoGuns(Pilot); {upgrade guns}
                't' : DoThrusters(Pilot); {upgrade thrusters}
                's' : DoShields(Pilot); {upgrade shields}
                'G' : DoGenerator(Pilot); {upgrade generators}
                'S' : DoSpecials(Pilot); {upgrade special weapons}
                'x' : Leave := true {EXIT chosen}
           end; {case}
           cleardevice
     until Leave;
     But.Destruct {deallocate all memory for buttons}
end; {DoUpgrades}

procedure DoSave(var Pilot : Person);

{Pre:  None.
 Post: Game is saved if necessary}

var
   But : OldButtonObject; {buttons}
   Mse : MouseObject; {mouse}
   Choice : string; {button choice}
   IniFile, TempIni : text; {files}
   SaveFile, tempsave : file of Person; {Save files}
   num : integer; {counter}
   ctr : integer; {counter}
   tstr : string; {temp. string}
   ch : char; {temp. char}
   TempRec : Person; {Temp. record}

begin {DoSave}
     cleardevice;
     settextjustify(CenterText, CenterText);
     settextstyle(TriplexFont, HorizDir, 3);
     OutTextXY(320, 180, 'Do you really want to save?'); {Prompt}
     But.init;                   {set up buttons}
     But.SetShadowLength(1);
     But.SetRadiusLength(1);
     But.SetTextColor(MenuTextColor);
     But.SetTextFont(SmallFont);
     But.SetTextSize(6);
     But.AddButton(200, 220, 300, 260, MenuButtonColor, 'YES', 'y'); {add buttons}
     But.AddButton(340, 220, 440, 260, MenuButtonColor, 'NO', 'n');

     But.ShowAllButtons; {show all buttons}
     Mse.showmouse; {show mouse cursor}
     Choice := But.TrapClick(Left_Button); {trap click}
     Mse.hidemouse; {hide mouse cursor}

     if Choice = 'y' then {If button pressed was YES}
        begin {if}
             assign(IniFile, GetPossPath(IniPaths, IniFileName)); {Find a path for .ini file}
             reset(IniFile);
             assign(TempIni, 'TEMPINI.TMP'); {set up temp. file}
             rewrite(TempIni);
             readln(IniFile, num);
             writeln(TempIni, num);
             for ctr := 1 to num do {copy all level file pointers to temp. file}
                 begin {for}
                      readln(IniFile, tstr); {get a line}
                      writeln(TempIni, tstr) {put a line}
                 end; {for}
             readln(IniFile, num); {get number of savegames}
             writeln(TempIni, num + 1); {Put number + 1}
             close(TempIni);
             close(IniFile);
             rewrite(IniFile);
             reset(TempIni);
             while not(eof(TempIni)) do {copy temp. file to .ini file}
                   begin {while}
                        read(TempIni, ch); {get a char}
                        write(IniFile, ch) {put a char}
                   end; {while}
             close(TempIni);
             close(IniFile);
             erase(TempIni); {delete temp. file}
             assign(SaveFile, GetPossPath(IniPaths, 'SAVE.ALI')); {get path for save file}
             reset(SaveFile);
             assign(TempSave, 'temp0000.ali');
             rewrite(TempSave);
             for ctr := 1 to num do {copy old save file to temp file}
                 begin {for}
                      read(SaveFile, TempRec);
                      write(TempSave, TempRec)
                 end; {for}
             write(TempSave, Pilot); {add new record to temp file}
             close(TempSave);
             close(SaveFile);
             reset(TempSave);
             rewrite(SaveFile);
             for ctr := 1 to num + 1 do {copy temp file to save file}
                 begin {for}
                      read(TempSave, TempRec);
                      write(SaveFile, temprec)
                 end; {for}
             close(TempSave);
             close(SaveFile);
             erase(Tempsave) {delete temp file}
        end; {if}

     But.destruct {deallocate all memory for buttons}
end; {DoSave}

procedure ShowMoney(Money : longint);

{Pre:  None.
 Post: Shows how much money you have}

begin {ShowMoney}
     setcolor(LightCyan);
     settextstyle(SmallFont, HorizDir, 6);
     settextjustify(LeftText, CenterText); {Set up text styles}
     if Money <> 1 then {If plural number of credits}
        OutTextXY(10, 20, 'YOUR MONEY: ' + LongToString(Money) + ' CREDITS')
     else {If singular}
         OutTextXY(10, 20, 'YOUR MONEY: 1 CREDIT')
end; {ShowMoney}

procedure EraseMoney;

{Pre:  None.
 Post: Erases amt. of money}

begin {EraseMoney}
     setfillstyle(SolidFill, Black); {Draw black rectangle to black out old credit meter}
     bar(2, 10, 300, 30)
end; {EraseMoney}

procedure ShowScore(Score : longint);

{Pre:  None.
 Post: Shows how many points you have}

begin {ShowScore}
     setcolor(LightCyan);
     settextstyle(SmallFont, HorizDir, 6);
     settextjustify(RightText, CenterText); {Set up text styles}
     if Score <> 1 then {If plural number of credits}
        OutTextXY(630, 20, 'YOUR SCORE: ' + LongToString(Score) + ' POINTS')
     else {If singular}
         OutTextXY(630, 20, 'YOUR SCORE: 1 POINT')
end; {ShowScore}

procedure EraseScore;

{Pre:  None.
 Post: Erases score}

begin {EraseScore}
     setfillstyle(SolidFill, Black); {Draw black rectangle to black out old score}
     bar(310, 10, 638, 30)
end; {EraseScore}

procedure Insufficient;

{Pre:  None.
 Post: Shows error message on screen}

begin {Insufficient}
     settextstyle(SmallFont, HorizDir, 4);
     settextjustify(CenterText, CenterText);
     setcolor(LightRed); {Prepare text styles}
     OutTextXY(320, 75, 'INSUFFICIENT CREDIT!'); {show error message}
     delay(1000); {wait}
     setcolor(Black);
     OutTextXY(320, 75, 'INSUFFICIENT CREDIT!') {erase error message}
end; {Insufficient}

procedure CheckNewLife(var Pilot : Person);

{Pre:  None.
 Post: Shows if you have enough points to earn a new life}

begin {CheckNewLife}
     while Pilot.Points >= Pilot.LastLifeUp + LIFE_POINTS do {Keep checking for new life}
        begin {while}
             Inc(Pilot.LastLifeUp, LIFE_POINTS); {Increment flag by number of points necessary for new life}
             Inc(Pilot.Lives); {Increment number of lives by 1}
             settextstyle(SmallFont, HorizDir, 4);
             settextjustify(CenterText, CenterText); {Prepare text style}
             setcolor(LightCyan);
             OutTextXY(320, 465, 'BONUS LIFE!'); {show message}
             delay(1000); {wait}
             setcolor(Black);
             OutTextXY(320, 465, 'BONUS LIFE!') {erase message}
        end {while}
end; {CheckNewLife}

procedure DoBank(var Pilot : Person);

{Pre:  None.
 Post: All banking operations are performed.}

var
   par : ParaType; {Flashing text}
   But : OldButtonObject; {buttons}
   Mse : MouseObject; {mouse}
   Choice : string; {button choice}
   Leave : boolean; {flag}

begin {DoBank}
     cleardevice;
     par[1] := 'WELCOME TO THE AUTOMATED BANKING SYSTEM!                    '; {Prepare text for flashing}
     par[2] := 'ALL TRANSACTIONS WILL BE REFLECTED IN                       ';
     par[3] := 'YOUR CREDIT ACCOUNT.                                        ';
     Fnt.psflashpara(45, 100, FlashSize, Green, 12, 20, 3, 40, FlashSpeed, 3, par); {Flash text}
     cleardevice;
     But.init;                               {Set up buttons}
     But.SetShadowLength(1);
     But.SetRadiusLength(1);
     But.SetTextColor(MenuTextColor);
     But.SetTextFont(SmallFont);
     But.SetTextSize(6);
     settextstyle(SmallFont, HorizDir, 6);
     settextjustify(LeftText, CenterText);
     setcolor(LightCyan);
     OutTextXY(100, 50, 'CONVERT:'); {show prompt}
     But.AddButton(100, 100, 200, 150, MenuButtonColor, '1 CREDIT', '1');    {Add buttons}
     But.AddButton(100, 200, 200, 250, MenuButtonColor, '5 CREDITS', '2');
     But.AddButton(100, 300, 200, 350, MenuButtonColor, '10 CREDITS', '3');
     But.AddButton(100, 400, 200, 450, MenuButtonColor, '25 CREDITS', '4');
     But.AddButton(500, 100, 600, 450, MenuButtonColor, 'EXIT', 'EXIT');
     OutTextXY(300, 125, 'TO 10 POINTS');
     OutTextXY(300, 225, 'TO 100 POINTS');
     OutTextXY(300, 325, 'TO 500 POINTS');
     OutTextXY(300, 425, 'TO 2500 POINTS');  {Show message}
     ShowMoney(Pilot.Money); {Show money}
     ShowScore(Pilot.Points); {Show score}

     Leave := false;
     repeat {Wait until EXIT is pressed}
           But.ShowAllButtons; {show all buttons}
           EraseMoney; {erase money indicator}
           EraseScore; {erase score indicator}
           ShowMoney(Pilot.Money); {show money indicator}
           ShowScore(Pilot.Points); {show score indicator}
           Mse.ShowMouse; {show mouse cursor}
           Choice := But.TrapClick(Left_Button); {trap click}
           Mse.HideMouse; {hide mouse cursor}
           case Choice[1] of {Branch based on what button was pressed}
                '1' : if Pilot.Money < 1 then {If not enough money}
                         Insufficient {Error}
                      else {Enough money}
                          begin {else}
                               Pilot.Money := Pilot.Money - 1; {Lose 1 credit}
                               Pilot.Points := Pilot.Points + 10; {Gain 10 pts}
                               CheckNewLife(Pilot) {Check to see if a new life was gained}
                          end; {else}
                '2' : if Pilot.Money < 5 then {If not enough money}
                         Insufficient {Error}
                      else {Enough money}
                          begin {else}
                               Pilot.Money := Pilot.Money - 5; {Lose 5 credits}
                               Pilot.Points := Pilot.Points + 100; {Gain 100 pts}
                               CheckNewLife(Pilot) {Check to see if a new life was gained}
                          end; {else}
                '3' : if Pilot.Money < 10 then {If not enough money}
                         Insufficient {Error}
                      else {Enough money}
                          begin {else}
                               Pilot.Money := Pilot.Money - 10; {Lose 10 credits}
                               Pilot.Points := Pilot.Points + 500; {Gain 500 pts}
                               CheckNewLife(Pilot) {Check to see if a new life was gained}
                          end; {else}
                '4' : if Pilot.Money < 25 then {If not enough money}
                         Insufficient {Error}
                      else {Enough money}
                          begin {else}
                               Pilot.Money := Pilot.Money - 25; {Lose 25 credits}
                               Pilot.Points := Pilot.Points + 2500; {Gain 2500 pts}
                               CheckNewLife(Pilot) {Check to see if a new life was gained}
                          end; {else}
                'E' : Leave := true {EXIT chosen}
           end {case}
     until Leave;
     But.Destruct {deallocate all memory for buttons}
end; {DoBank}