procedure AddAlien(EShips : EShipPtr; Class : byte);

{Pre:  None.
 Post: New alien added to EShips linked list}

var
   ins : EShipPtr; {Insertion ptr}

begin {AddAlien}
     new(ins);
     with ins^ do {Init record}
          begin {with}
               what := Class;
               Shields := (Class) * 5 + 1;
               mov := 0;
               shoot := 0;
               Bearing.theta := random(360) * Pi/180; {Random bearing}
               Bearing.mag := (random(2) + 1) * 2;
               case random(4) of {Random starting place}
                    0 : begin {0}
                             Position.X := 0;
                             Position.Y := random(MaxGameY)
                        end; {0}
                    1 : begin {1}
                             Position.X := 640;
                             Position.Y := random(MaxGameY)
                        end; {1}
                    2 : begin {2}
                             Position.X := random(640);
                             Position.Y := 0
                        end; {2}
                    3 : begin {3}
                             Position.X := random(640);
                             Position.Y := MaxGameY
                        end {3}
               end;
               prev := EShips; {Link}
               next := EShips^.next
          end; {with}
     ins^.next^.prev := ins; {Link}
     EShips^.next := ins
end; {AddAlien}