procedure firebullet(var You : YShipType; var Projs : ProjPtr);

{Pre:  Projs defined.
 Post: bullet fired and inserted into Projs linked list}

var
   cur : ProjPtr; {Insertion ptr}

begin {firebullet}
     You.Power := You.Power - BULLET_POWER; {Lose power}
     if SoundPlaying(BULLET_SOUND) then {If bullet sound playing} {FIX}
        StopSound(BULLET_SOUND); {stop it}
     StartSound(Sound[BULLET_SOUND], BULLET_SOUND, false); {start it}
     new(cur);
     with cur^ do
          begin {with}
               what := BULLET;
               AddVecs(You.aim, BULLET_SPEED, You.bearing.theta, You.bearing.mag, Bearing);
                {set its direction vector}
               Position.X := You.Position.X + 11 * cos(cur^.Bearing.theta);
               Position.Y := You.Position.Y + 11 * sin(cur^.Bearing.theta);
               move := 0;
               range := BULLET_RANGE;
               prev := Projs; {Link}
               next := Projs^.next
          end; {with}
     Projs^.next := cur; {Link}
     cur^.next^.prev := cur;
     AddVecs(You.bearing.theta, You.bearing.mag, You.aim, RECOIL_INCREMENT, You.bearing);
      {Make you recoil}
     if You.bearing.mag > Y_MAX_VELOCITY then {Make sure you aren't going too fast}
        You.bearing.mag := Y_MAX_VELOCITY
end; {firebullet}

procedure firespray(var You : YShipType; var Projs : ProjPtr; Num : integer);

{Pre:  Projs defined.
 Post: bullets fired and inserted into Projs linked list}

var
   ins : ProjPtr; {Insertion ptr}
   ctr : integer; {counter}

begin {firespray}
     You.Power := You.Power - Num * SPRAY_POWER; {Lose power}
     if SoundPlaying(BULLET_SOUND) then {If bullet sound playing}
        StopSound(BULLET_SOUND); {stop it}
     StartSound(Sound[BULLET_SOUND], BULLET_SOUND, false); {start it}
     for ctr := 1 to Num do {Insert number of spray bullets}
         begin {for}
              new(ins);
              with ins^ do
                   begin {with}
                        what := BULLET;
                        AddVecs(You.aim - SPRAY_ANGLE * (Num - 1)/2 + SPRAY_ANGLE * (ctr - 1),
                                BULLET_SPEED, You.bearing.theta, You.bearing.mag, Bearing);
                         {set its direction vector}
                        Position.X := You.Position.X + 11 * cos(Bearing.theta);
                        Position.Y := You.Position.Y + 11 * sin(Bearing.theta);
                        move := 0;
                        range := BULLET_RANGE;
                        prev := Projs; {Link}
                        next := Projs^.next
                   end; {with}
              ins^.next := Projs^.next; {Link}
              ins^.prev := Projs;
              Projs^.next := ins;
              ins^.next^.prev := ins
         end; {for}

     AddVecs(You.bearing.theta, You.bearing.mag, You.aim, Num * RECOIL_INCREMENT, You.bearing);
      {Make you recoil}
     if You.bearing.mag > Y_MAX_VELOCITY then {Make sure you aren't going too fast}
        You.bearing.mag := Y_MAX_VELOCITY
end; {firespray}

procedure firepowergun(var You : YShipType; var Projs : ProjPtr);

{Pre:  Projs defined.
 Post: Power bullet fired and inserted into Projs linked list}

var
   cur : ProjPtr; {insertion ptr}

begin {firepowergun}
     You.Power := You.Power - POWERGUN_POWER; {Lose power}
     if SoundPlaying(E_BULLET_SOUND) then {Do sound stuff}
        StopSound(E_BULLET_SOUND);
     StartSound(Sound[E_BULLET_SOUND], E_BULLET_SOUND, false);
     new(cur);
     with cur^ do {Init record}
          begin {with}
               what := POWERGUN_BULLET;
               AddVecs(You.aim, BULLET_SPEED, You.bearing.theta, You.bearing.mag, Bearing);
               Position.X := You.Position.X + 11 * cos(cur^.Bearing.theta);
               Position.Y := You.Position.Y + 11 * sin(cur^.Bearing.theta);
               move := 0;
               range := POWERGUN_BULLET_RANGE;
               prev := Projs;
               next := Projs^.next
          end; {with}
     Projs^.next := cur;
     cur^.next^.prev := cur;
     AddVecs(You.bearing.theta, You.bearing.mag, You.aim, RECOIL_INCREMENT, You.bearing);
      {You recoil}
     if You.bearing.mag > Y_MAX_VELOCITY then
        You.bearing.mag := Y_MAX_VELOCITY
end; {firepowergun}

procedure firelaserpulse(var You : YShipType; var Projs : ProjPtr);

{Pre:  Projs defined.
 Post: Laser pulse fired and inserted into Projs linked list}

var
   cur : ProjPtr; {Insertion ptr}

begin {firelaserpulse}
     You.Power := You.Power - LASERPULSE_POWER; {Lose power}
     if SoundPlaying(LASER_SOUND) then {Do sounds}
        StopSound(LASER_SOUND);
     StartSound(Sound[LASER_SOUND], LASER_SOUND, false);
     new(cur);
     with cur^ do {Init record}
          begin {with}
               what := LASERPULSE_PULSE;
               AddVecs(You.aim, LASERPULSE_SPEED, You.bearing.theta, You.bearing.mag, Bearing);
               Position.X := You.Position.X + 11 * cos(cur^.Bearing.theta);
               Position.Y := You.Position.Y + 11 * sin(cur^.Bearing.theta);
               move := 0;
               range := LASERPULSE_PULSE_RANGE;
               prev := Projs;
               next := Projs^.next
          end; {with}
     Projs^.next := cur;
     cur^.next^.prev := cur;
     AddVecs(You.bearing.theta, You.bearing.mag, You.aim, RECOIL_INCREMENT, You.bearing);
      {You recoil}
     if You.bearing.mag > Y_MAX_VELOCITY then
        You.bearing.mag := Y_MAX_VELOCITY
end; {firelaserpulse}

procedure fire2laserpulse(var You : YShipType; var Projs : ProjPtr);

{Pre:  Projs defined.
 Post: Laser pulse fired and inserted into Projs linked list}

var
   cur : ProjPtr; {Insertion ptr}

begin {fire2laserpulse}
     You.Power := You.Power - 2 * LASERPULSE_POWER; {Lose power}
     if SoundPlaying(LASER_SOUND) then {Do sounds}
        StopSound(LASER_SOUND);
     StartSound(Sound[LASER_SOUND], LASER_SOUND, false);
     new(cur);
     with cur^ do {Init record}
          begin {with}
               what := LASERPULSE_PULSE;
               Bearing.theta := You.aim;
               Bearing.mag := LASERPULSE_SPEED;
               Position.X := You.Position.X + 11 * cos(cur^.Bearing.theta);
               Position.Y := You.Position.Y + 11 * sin(cur^.Bearing.theta);
               move := 0;
               range := LASERPULSE_PULSE_RANGE;
               prev := Projs;
               next := Projs^.next
          end; {with}
     Projs^.next := cur;
     cur^.next^.prev := cur;
     new(cur);
     with cur^ do {Init record}
          begin {with}
               what := LASERPULSE_PULSE;
               Bearing.theta := You.aim + Pi;
               Bearing.mag := LASERPULSE_SPEED;
               Position.X := You.Position.X + 11 * cos(cur^.Bearing.theta + Pi);
               Position.Y := You.Position.Y + 11 * sin(cur^.Bearing.theta + Pi);
               move := 0;
               range := LASERPULSE_PULSE_RANGE;
               prev := Projs;
               next := Projs^.next
          end; {with}
     Projs^.next := cur;
     cur^.next^.prev := cur;
     if You.bearing.mag > Y_MAX_VELOCITY then
        You.bearing.mag := Y_MAX_VELOCITY
end; {fire2laserpulse}

procedure LaunchSpecial(var You : YShipType; var Projs : ProjPtr; var Pilot : Person);

{Pre:  Projs defined.
 Post: Special weapon dropped and inserted into Projs linked list}

var
   cur : ProjPtr; {Insertion ptr}
   ctr : integer; {counter}
   hr, mn, sc, sc100, curtime : longint; {Time}

begin {LaunchSpecial}
     if Pilot.SpePosition = 0 then {If pilot has no specials}
        exit; {leave}
     pGetTime(hr, mn, sc, sc100); {get time}
     curtime := 360000 * hr + 6000 * mn + 100 * sc + sc100; {set time counter}
     if (Pilot.SpePosition = SUPERSHIELD) and (curtime <= You.InvulnerableStay) then
      {If the supershield is activated but you are on it}
        exit {Leave}
     else if Pilot.SpePosition = SUPERSHIELD then {If it is activated}
          begin {else-if}
               if SoundPlaying(SUPERSHIELD_SOUND) then {If sound playing}
                  StopSound(SUPERSHIELD_SOUND); {stop it}
               StartSound(Sound[SUPERSHIELD_SOUND], SUPERSHIELD_SOUND, false); {start it}
               You.InvulnerableStay := curtime + INVULNERABLE_TIME; {Add invulnerable time}
               if not(Cheat) then {if not cheating}
                  Dec(Pilot.Specials[Pilot.SpePosition]); {Lose 1}
               if Pilot.Specials[Pilot.SpePosition] = 0 then {Set new speposition}
                  begin {if}
                       Pilot.SpePosition := 0;
                       for ctr := 1 to NumSpecials do {Find one special}
                           if Pilot.Specials[ctr] > 0 then
                              Pilot.SpePosition := ctr
                  end; {if}
               exit {Leave}
          end; {else-if}
     if SoundPlaying(LASER_SOUND) then {Do sounds}
        StopSound(LASER_SOUND);
     StartSound(Sound[LASER_SOUND], LASER_SOUND, false);
     if not(Cheat) then {If not cheating}
        Pilot.Specials[Pilot.SpePosition] := Pilot.Specials[Pilot.SpePosition] - 1; {Use up one}
     new(cur);
     if Pilot.SpePosition = AAMINE then {If it's a aa-mine}
        with cur^ do {Init record}
             begin {with}
                  what := SPE_OFFSET + Pilot.SpePosition;
                  AddVecs(You.aim + Pi, SPECIAL_VELOCITY, You.bearing.theta, You.bearing.mag, Bearing);
                  Position.X := You.Position.X + 11 * cos(You.aim + Pi);
                  Position.Y := You.Position.Y + 11 * sin(You.aim + Pi);
                  move := 0;
                  prev := Projs;
                  next := Projs^.next
             end {with}
     else if Pilot.SpePosition = MEGAMISSILE then {If it's a mega-missile}
          with cur^ do {Init record}
               begin {with}
                    what := SPE_OFFSET + Pilot.SpePosition;
                    AddVecs(You.aim, MEGAMISSILE_VELOCITY, You.bearing.theta, You.bearing.mag, Bearing);
                    Position.X := You.Position.X + 11 * cos(You.aim);
                    Position.Y := You.Position.Y + 11 * sin(You.aim);
                    range := MEGAMISSILE_RANGE;
                    move := 0;
                    prev := Projs;
                    next := Projs^.next
               end; {with}
     Projs^.next := cur;
     cur^.next^.prev := cur;
     if Pilot.Specials[Pilot.SpePosition] = 0 then {Set new speposition}
        begin {if}
             Pilot.SpePosition := 0;
             for ctr := 1 to NumSpecials do {Find one special}
                 if Pilot.Specials[ctr] > 0 then
                    Pilot.SpePosition := ctr
        end {if}
end; {LaunchSpecial}

procedure FireEBullet(EShip : EShipPtr; var Projs : ProjPtr; You : YShipType);

{Pre:  Projs defined.
 Post: Enemy bullet fired and inserted into Projs linked list}

var
   ins : ProjPtr; {Insertion pounter}

begin {FireEBullet}
     if SoundPlaying(E_BULLET_SOUND) then {Do sounds}
        StopSound(E_BULLET_SOUND);
     StartSound(Sound[E_BULLET_SOUND], E_BULLET_SOUND, false);
     new(ins);
     with ins^ do {Init record}
          begin {with}
               what := BULLET;
               if EShip^.Position.X < You.Position.X then {Calculate bearing}
                  Bearing.theta := arctan((You.Position.Y - EShip^.Position.Y) / (You.Position.X - EShip^.Position.X))
               else if EShip^.Position.X = You.Position.X then
                    if EShip^.Position.Y <= You.Position.Y then
                       Bearing.theta := Pi/2
                    else
                        Bearing.theta := 3 * Pi / 2
               else
                   Bearing.theta := arctan((You.Position.Y - EShip^.Position.Y) / (You.Position.X - EShip^.Position.X)) + Pi;
               Bearing.mag := E_BULLET_SPEED; {Set speed of bullet}
               Position.X := EShip^.Position.X + (GUNSHIP_1_RADIUS + 2) * cos(Bearing.theta);
               Position.Y := EShip^.Position.Y + (GUNSHIP_1_RADIUS + 2) * sin(Bearing.theta);
               move := 0;
               range := E_BULLET_RANGE;
               prev := Projs;
               next := Projs^.next
          end; {with}
     Projs^.next := ins; {Link}
     ins^.next^.prev := ins
end; {FireEBullet}

function GetTheta(XY1, XY2 : Coord) : real;

{Pre:  None.
 Post: returns angle from XY1's coords to XY2's coords.}

begin {GetTheta}
     if XY1.X < XY2.X then {Calculate angle through Pre-Calculus methods}
        GetTheta := arctan((XY2.Y - XY1.Y) / (XY2.X - XY1.X))
     else if XY1.X = XY2.X then
          if XY1.Y <= XY2.Y then
             GetTheta := Pi/2
          else
              GetTheta := 3 * Pi/2
     else
         GetTheta := arctan((XY2.Y - XY1.Y) / (XY2.X - XY1.X)) + Pi
end; {GetTheta}

function FindNearest(Mine : ProjPtr; EShips : EShipPtr) : EShipPtr;

{Pre:  The function dist is defined.
 Post: The closest enemy to the mine is located}

var
   cur : EShipPtr; {traversion ptr}
   least : EShipPtr; {indication ptr}
   leastdist : real; {least distance to enemy}

begin {FindNearest}
     least := EShips^.next;
     leastdist := dist(Mine^.Position.X, Mine^.Position.Y, least^.Position.X, least^.Position.Y);
      {find distance}
     cur := EShips^.next^.next;
     while cur <> EShips do {Search for closest enemy}
           begin {while}
                if dist(cur^.Position.X, cur^.Position.Y, Mine^.Position.X, Mine^.Position.Y) <
                   leastdist then {If this enemy is closer}
                      begin {if}
                           least := cur;
                           leastdist := dist(Mine^.Position.X, Mine^.Position.Y, least^.Position.X, least^.Position.Y)
                            {calculate new least distance}
                      end; {if}
                cur := cur^.next
           end; {while}
     FindNearest := least {return ptr. to closest enemy}
end; {FindNearest}